% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_filters.R
\name{findEOP}
\alias{findEOP}
\title{Find Events Overlapping Primers.}
\usage{
findEOP(aln, cfgT)
}
\arguments{
\item{aln}{(data.frame) Should contain events from alignments in GRanges
style with columns eg. seqnames, width, start, end.}

\item{cfgT}{(data.frame) Needs columns Forward_Primer, ReversePrimer and
Amplicon.}
}
\value{
(logical vector) where TRUE indicates events that are overlapping
primers
}
\description{
Very often alignments return deletions that are not real deletions, but
rather artifact of incomplete reads eg.: \cr
\preformatted{
ACTGAAAAA------- <- this "deletion" should be filtered
ACTG----ACTGACTG
}
}
\examples{
file_path <- system.file("extdata", "results", "alignments",
                         "raw_events.csv", package = "amplican")
aln <- data.table::fread(file_path)
cfgT <- data.table::fread(
  system.file("extdata", "results", "config_summary.csv",
              package = "amplican"))
findEOP(aln, cfgT)

}
\seealso{
\code{\link{findPD}} \code{\link{findLQR}}

Other filters: 
\code{\link{findLQR}()},
\code{\link{findPD}()}
}
\concept{filters}
