% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSpatialExperiment.R
\name{readSpatialExperiment}
\alias{readSpatialExperiment}
\alias{loadSpatialExperiment}
\title{Read a SpatialExperiment from disk}
\usage{
readSpatialExperiment(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created using the \code{\link{saveObject}} method for \linkS4class{SpatialExperiment} objects.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments passed to \code{\link{readSingleCellExperiment}} and internal \code{\link{altReadObject}} calls.}
}
\value{
A \linkS4class{SpatialExperiment} object.
}
\description{
Read a \linkS4class{SpatialExperiment} object from its on-disk representation.
}
\examples{
library(SpatialExperiment)
example(read10xVisium, echo=FALSE)

tmp <- tempfile()
saveObject(spe, tmp)
readObject(tmp)

}
\seealso{
\code{"\link{saveObject,SpatialExperiment-method}"}, to save a SpatialExperiment to disk.
}
\author{
Aaron Lun
}
