% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneSetTables.R
\name{gsHeatmap}
\alias{gsHeatmap}
\title{A function to create a simple heatmap and key.}
\usage{
gsHeatmap(
  object,
  ind,
  filename,
  columns = NULL,
  colnames = NULL,
  col = NULL,
  annot = NULL,
  scale.row = FALSE,
  key = TRUE,
  bline = NULL
)
}
\arguments{
\item{object}{An \code{\link{ExpressionSet}} containing normalized, summarized
gene expression data.}

\item{ind}{Numeric vector indicating which rows of the
\code{\link{ExpressionSet}} to use.}

\item{filename}{The filename for the heatmap and associated key.}

\item{columns}{Numeric vector indicating which columns of the
\code{\link{ExpressionSet}} to use. If \code{NULL}, all columns will be
used.}

\item{colnames}{Character. Substitute column names for the heatmap. If
\code{NULL}, the sampleNames will be used.}

\item{col}{A vector of colors to use for the heatmap. If \code{NULL}, the
\code{\link{bluered}} function will be used.}

\item{annot}{A matrix or data.frame containing gene symbols to annotate the heatmap.
This will normally be extracted automatically from the 'fit' object passed to geneSetPage.
If there is no annotation in the fit object, then the probe IDs will be used instead.}

\item{scale.row}{Boolean. Should the data be scaled by row? Defaults to
\code{FALSE}.}

\item{key}{Boolean. Should a key be produced that shows the numeric range
for the colors of the heatmap? Defaults to \code{TRUE}.}

\item{bline}{A numeric vector, usually extracted from a contrast matrix,
used to \sQuote{sweep} the mean baseline sample means from the heatmap data.
The end result will be a heatmap in which the colors correspond to log fold
changes from the baseline samples.}
}
\value{
Nothing is returned. Called only for the side effect of creating
heatmaps in 'png' format.
}
\description{
This is an internal function called by \code{runRomer} and is not intended
to be used directly. It is documented here only because arguments may be
passed down via the \code{dots} argument.
}
\details{
As noted above, this is only intended to be called indirectly by
\code{runRomer}. However, certain arguments such as scale.row, or col, etc,
can be passed down to this function via the \code{dots} argument, allowing
the end user to have more control over the finished product.
}
\author{
James W. MacDonald <jmacdon@u.washington.edu>
}
