% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affystart.R
\name{getMainProbes}
\alias{getMainProbes}
\title{Remove control probesets from ST arrays}
\usage{
getMainProbes(input, level = "core")
}
\arguments{
\item{input}{Either a character string (e.g., "pd.hugene.1.0.st.v1") or a
FeatureSet object.}

\item{level}{The summarization level used when calling rma.}
}
\value{
If the argument is a character string, returns a data.frame
containing probeset IDs along with the probeset type, that can be used to
subset e.g., an ExpressionSet of Gene ST data, or an MArrayLM object created
from Gene ST data. Note that the order of the probesets is not guaranteed to
match the order in your ExpressionSet or MArrayLM object, so that should be
checked first. If the argument is a FeatureSet object, it returns a
FeatureSet object with only main probes remaining.
}
\description{
This function is designed to remove all but the 'main' type of probesets
from the Gene ST array types.
}
\author{
James W. MacDonald <jmacdon@u.washington.edu>
}
\keyword{manip}
