% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictWithNewValue.R
\name{predictWithNewValue}
\alias{predictWithNewValue}
\title{Returns a classification and an odd value from a
RNA expression DelayedMatrix or a SingleCellExperiment object,
for given genes, for a given cluster, for a given modification.}
\usage{
predictWithNewValue(
  exprs,
  genes,
  clusters,
  target,
  classifier,
  advMethod = "perc99",
  advFixedValue = 3,
  advFct = NULL,
  argForClassif = "data.frame",
  argForModif = "data.frame",
  slot = NULL,
  verbose = FALSE
)
}
\arguments{
\item{exprs}{DelayedMatrix of numeric RNA expression, cells are rows and genes
are columns - or a SingleCellExperiment object, a matrix or a data.frame.}

\item{genes}{the character vector of genes to modify}

\item{clusters}{a character vector of the clusters to which the cells belong}

\item{target}{the name of the cluster to modify}

\item{classifier}{a classifier in the suitable format.
A classifier function should be formated as follow:
classifier = function(expr, clusters, target){
# Making the classification
c("cell type", score)
}
\code{score} should be numeric between 0 and 1, 1 being the highest confidance
into the cell type classification.
The matrix \code{expr} contains RNA expression values, the vector \code{clusters}
consists of the cluster IDs for each cell in \code{expr}, and \code{target} is the
ID of the cluster for which we want to have a classification.
The function returns a vector with the classification result, and a score.}

\item{advMethod}{the name of the method to use}

\item{advFixedValue}{the numeric value to use in case of
advMethod=\code{fixed}}

\item{advFct}{the function to use in case advMethod
belongs to the following list: \code{full_row_fct}, \code{target_row_fct},
\code{target_matrix_fct}, \code{full_matrix_fct}}

\item{argForClassif}{the type of the first argument to feed to the
classifier function. 'data.frame' by default, can be 'SingleCellExperiment'
or 'DelayedMatrix'.}

\item{argForModif}{type of matrix during for the modification, 'data.frame'
by default. Can be 'DelayedMatrix', which is slower, but need less memory.}

\item{verbose}{logical, set to TRUE to activate verbose mode}
}
\value{
a vector of the classification, and the associated odd
}
\description{
Returns a classification and an odd value from a
RNA expression DelayedMatrix or a SingleCellExperiment object,
for given genes, for a given cluster, for a given modification.
}
\details{
This function aims to concatenate the following actions:
\itemize{
\item modify the RNA gene expression
\item classify the result
This is a widely used function in the other functions of the package.
}
}
\examples{
library(DelayedArray)

MyClassifier <- function(expr, clusters, target) {
   c("T cell", 0.9)
}
rna_expression <- DelayedArray(data.frame(CD4=c(0,0,0,0),
     CD8A=c(1,1,1,1),
     CD8B=c(2,2,3,3)))
genes <- c("CD4", "CD8A")
clusters_id <- c("B cell","B cell","T cell","T cell")

predictWithNewValue(rna_expression, genes, clusters_id,
"T cell", MyClassifier, advMethod="perc99")
}
