% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputPeakTable.R
\name{outputPeakTable}
\alias{outputPeakTable}
\title{output peak table from AdductQuantif object}
\usage{
outputPeakTable(object = NULL, outputDir = NULL)
}
\arguments{
\item{object}{a 'AdductQuantif' class object}

\item{outputDir}{character full path to a directory to output the peak to
default is the current working directory}
}
\value{
a peaktable with number of rows equal to the number of adducts
quantified and 14 peak group information columns plus a number of columns
equal to the number of samples quantified. 
The peak table is saved as a csv file in the output directory
named: adductQuantif_peakList_'todays date'.csv. 
The peak table is also returned to
the R session and can be assigned to an object.
}
\description{
output peak table from AdductQuantif object
}
\examples{
eh = ExperimentHub();
Temp = query(eh, c("adductData", "adductQuant", "Rda"))[[1]];
outputPeakTable(object=Temp)
}
