#'Make a target table for adductomicsR quantificaton using
#'specSimPep results
#'@param allresultsFile character a full path to the allResults
#'file generated by specSimPepId
#'@param csvDir character a full path to a directory to save the
#'csv file to
#'output is a csv file called targTable.csv which can be used
#'in the adductQuant function
#'@examples
#'generateTargTable(paste0(system.file("extdata",package="adductomicsR"),
#''/allResults_ALVLIAFAQYLQQCPFEDHVK_example.csv'),csvDir=getwd())
#'@usage generateTargTable(allresultsFile = NULL, csvDir = NULL)
#'@return cvs file
#'@export
generateTargTable <-
    function(allresultsFile = NULL,
            csvDir = NULL) {
        MIM = NULL
        adjMIM = NULL
        RT = NULL
        adjRT = NULL
        MSMSGroupsName = NULL
        data = read.csv(allresultsFile, sep = ",", header = TRUE)
        groups = unique(data$MSMSGroupsName)
        # obtain unique groups with average RT and MIM
        data2 <-
            data.frame(
                dplyr::summarise(
                    dplyr::group_by(data, MSMSGroupsName),
                    MIM = mean(MIM),
                    adjMIM <- mean(adjMIM),
                    RT = mean(RT),
                    adjRT = mean(adjRT)
                )
            )
        data2 <- data2[-(nrow(data2)),]
        # create a target table based on the non adjusted results
        targ <- data.frame(
            mass = data2$MIM,
            RT = data2$RT,
            peptide = rep("ALVLIAFAQYLQQCPFEDHVK",
                        length(nrow(data2))),
            chargeState = rep(3, length(nrow(data2)))
        )
        hk <-
            data.frame(
                mass = 575.31113,
                RT = 13.55,
                peptide = "LVNEVTEFAK",
                chargeState = 2
            )
        targetTable <- rbind(hk, targ)
        write.table(
            targetTable,
            file = paste0(csvDir, "/targTable.csv"),
            sep = ",",
            quote = FALSE,
            row.names = FALSE
        )
    }
