% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{.loadMatrixFromDF}
\alias{.loadMatrixFromDF}
\title{Given a dataframe with the columns "from", "to", and value.var, return
a symmetric matrix (with diagonal values = diag). I.e. a call to
isSymmetric(return_value_of_this_function) will always be TRUE.}
\usage{
.loadMatrixFromDF(dataframe, value.var, diag, unidirectional = TRUE)
}
\arguments{
\item{dataframe}{dataframe with 3 required columns, namely:
+---------------------------------------+
| from | to | value.var | ...           |
+---------------------------------------+
|      |    |           |               |
+---------------------------------------+
where value.var is the string provided in the function parameter}

\item{value.var}{the column to use as the matrix value}

\item{diag}{what should the diagonal values be if the dataframe doesn't provide them}

\item{unidirectional}{logical type. If the dataframe provided has the reverse
pairs (i.e. a from-to pair AND a to-from pair with the save values in the
value.var column), then this should be FALSE. Otherwise, this function will
flip the from-to columns to generate a symmetric dataframe (and hence, a
symmetric matrix).}
}
\value{
a symmetric matrix with rownames(mat) == colnames(mat)
The diagonal values are filled with diag if the dataframe itself doesn't have
diagonal data
}
\description{
Given a dataframe with the columns "from", "to", and value.var, return
a symmetric matrix (with diagonal values = diag). I.e. a call to
isSymmetric(return_value_of_this_function) will always be TRUE.
}
