% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomForest.R
\name{rfClass}
\alias{rfClass}
\title{Classify using Random Forests}
\usage{
rfClass(object, groups, probe2gene = TRUE)
}
\arguments{
\item{object}{object containing the expression measurements; currently the
only method supported is one for ExpressionSet objects}

\item{groups}{character string indicating the column containing the class 
membership}

\item{probe2gene}{logical; if \code{TRUE} Affymetrix probeset IDs are translated
into gene symbols in the output object; if \code{FALSE} no such translation 
is conducted}
}
\value{
Object of class 'rfClass'
}
\description{
Classify using the Random Forest algorithm of Breiman (2001)
}
\note{
topTable and plot methods are available for 'rfClass' objects.
}
\examples{
if(require(ALL)){
 data(ALL, package = "ALL")
 ALL <- addGeneInfo(ALL)
 ALL$BTtype <- as.factor(substr(ALL$BT,0,1))
 # select only a subset of the data for computation time reason
 ALLSubset <- ALL[sample.int(n = nrow(ALL), size = 100, replace = TRUE), ]
 resultRf <- rfClass(object = ALLSubset, groups = "BTtype")
 plot(resultRf)
 topTable(resultRf, n = 15)
}
}
\references{
Breiman, L. (2001), \emph{Random Forests}, Machine Learning 45(1),
 5-32.
}
\seealso{
\code{\link[randomForest]{randomForest}}
}
\author{
Tobias Verbeke and Willem Talloen
}
\keyword{models}
