% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported.R
\name{aff_germ_copies}
\alias{aff_germ_copies}
\title{calculates how many copies are affected by a germnline small variant}
\usage{
aff_germ_copies(chr, af, tcn, purity, sex, c_normal = NULL, af_normal = 0.5)
}
\arguments{
\item{chr}{chromosome of the variant (either format 1,2,..,X,Y or 
chr1,..,chrX)}

\item{af}{Allele-frequency of the variant (numeric value between 0 and 1)}

\item{tcn}{total-copynumber at position of the variant (numeric value >0)}

\item{purity}{purity of the sample (numeric value between 0 and 1 indicating 
the fraction of relevant sample with control/unrelevant tissue)}

\item{sex}{sex of the sample (character: "male", "female", "m", "f")}

\item{c_normal}{expected copy number at position of the variant in normal 
tissue, 1 for gonosomes in male samples, and 2 for male autosomes and all 
chromosomes in female samples. (The function can also assess the c_normal 
parameter by itself, but then the following two inputs must be provided: 
chr and sex)}

\item{af_normal}{Allele-frequency in normal tissue (numeric value between 0 
and 1) 0.5 represents heterozygous variants in diploid genome, 
1 would be homozygous. Could be relevant if germline CNVs are present at the 
position. Then also the c_normal parameter would have to be adjusted.}
}
\value{
A numeric value indicating the affecting copies for the variant
}
\description{
calculates how many copies are affected by a germnline small variant
}
\examples{
library(dplyr)
library(purrr)
library(stringr)
aff_germ_copies(af=0.67, tcn=2, purity=0.9, chr="chrX", sex="female")
}
