% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{compare_expousre_sets}
\alias{compare_expousre_sets}
\title{Compare two sets of exposures by cosine distance}
\usage{
compare_expousre_sets(in_df_small, in_df_big, in_distance = cosineDist)
}
\arguments{
\item{in_df_small, in_df_big}{Numerical data frames \code{H1} and 
\code{H2}, ideally the bigger one first, both with \code{l} rows
and \code{m1} and \code{m2} columns, \code{l} being the number of
signatures and \code{m1} and \code{m2} being the respective numbers
of samples or patient identefier of \code{H1} and \code{H2}}

\item{in_distance}{A function which computes the distance measure, default
is \code{\link{cosineDist}}}
}
\value{
A list with entries
 \code{distance},
 \code{hierarchy_small} and
 \code{hierarchy_big}.
\itemize{
 \item \code{distance}:
   A numerical data frame with the cosine distances between the
   columns of \code{H1}, indexing the rows, and \code{H2}, indexing
   the columns
 \item \code{hierarchy_small}:
   A data frame carrying the information of ranked similarity between
   the signatures in \code{H2} with the signatures in \code{H1}
 \item \code{hierarchy_big}:
   A data frame carrying the information of ranked similarity between
   the signatures in \code{H1} with the signatures in \code{H2}
}
}
\description{
Compare two sets of exposures, stored in numerical data frames
\code{H1} and \code{H2}, by computing the row-wise cosine distance
}
\examples{
sig_1_df <- data.frame(matrix(c(1,0,0,0,0,1,0,0,0,0,1,0),ncol=3))
names(sig_1_df) <- paste0("B",seq_len(dim(sig_1_df)[2]))
sig_2_df <- data.frame(matrix(c(1,1,0,0,0,0,1,1),ncol=2))
compare_expousre_sets(sig_1_df,sig_2_df)

}
\seealso{
\code{\link{cosineDist}}
}
