% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_response_Function.R
\name{summarizeResponse}
\alias{summarizeResponse}
\title{Summarize Response of PDXs}
\usage{
summarizeResponse(
  object,
  response.measure = "mRECIST",
  model.id = NULL,
  batch.id = NULL,
  group.by = "patient.id",
  summary.stat = c(";", "mean", "median"),
  tissue = NULL
)
}
\arguments{
\item{object}{The \code{XevaSet} object.}

\item{response.measure}{\code{character} indicating which response measure to use. Use the \code{responseMeasures} function to find out what measures are available for each \code{XevaSet}.}

\item{model.id}{The \code{model.id} for which data is required.}

\item{batch.id}{A \code{vector} of batch names. Default \code{NULL} will return all batches.}

\item{group.by}{Default \code{patient.id}. Dictates how the models should be grouped together. See details below.}

\item{summary.stat}{Dictates which summary method to use if multiple IDs are found.}

\item{tissue}{Name of the tissue. Default \code{NULL}}
}
\value{
A \code{matrix} with rows as drug names, column as \code{group.by}. Each cell contains \code{response.measure} for the pair.
}
\description{
This function summarizes the drug response information of PDXs.
}
\details{
There can be two types of drug response measure.
\itemize{
\item{Per model response: One response value for each Model, eg. \code{mRECIST_recomputed} for each model.}
\item{Per batch response: One response value for each Batch, eg. \code{angle} between treatment and control groups.}
}
For the \code{per model response} output, columns will be \code{model.id} (or \code{group.by}).
For the \code{per batch response} output, the \code{group.by} value can be \code{"batch.name"}.
}
\examples{
data(brca)
brca.mR <- summarizeResponse(brca, response.measure = "mRECIST", group.by="patient.id")

}
