% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_plots.R
\name{plot_condition_compositions}
\alias{plot_condition_compositions}
\title{plot_condition_compositions}
\usage{
plot_condition_compositions(clustering_result, bullseye = FALSE,
  ggplot_theme = NULL)
}
\arguments{
\item{clustering_result}{A list containing XINA clustering results.
See \link[XINA]{xina_clustering}}

\item{bullseye}{If it is TRUE, draw bullseye plot instead of the pie-chart. Default is FALSE}

\item{ggplot_theme}{This is ggplot theme to modify condition composition pie-chart and bulles eye plots.}
}
\value{
A condition composition plot and a data frame containing condition compositions of the clusters
}
\description{
computes condition composition of the XINA clustering results and draws pie-charts.
}
\examples{

# load XINA example data
data(xina_example)

# Plot condition composition pie-chart with default option
plot_condition_compositions(example_clusters)

# Make a new color code for conditions
condition_colors <- c("tomato","steelblue1","gold")
names(condition_colors) <- example_clusters$condition
example_clusters$color_for_condition <- condition_colors

# Draw condition composition pie-chart with the new color code
plot_condition_compositions(example_clusters)

# Draw condition composition bullseye plot
plot_condition_compositions(example_clusters, bullseye = TRUE)

}
