% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-transcripts.R
\name{plotTxBin2D}
\alias{plotTxBin2D}
\title{Plot transcript spot density as 2D histogram}
\usage{
plotTxBin2D(
  sfe = NULL,
  data_dir = NULL,
  tech = c("Vizgen", "Xenium", "CosMX"),
  file = NULL,
  sample_id = "all",
  bins = 200,
  binwidth = NULL,
  hex = FALSE,
  ncol = NULL,
  bbox = NULL,
  gene = "all",
  spatialCoordsNames = c("X", "Y"),
  gene_col = "gene",
  rowGeometryName = "txSpots",
  flip = FALSE,
  tx_file = NULL
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{data_dir}{Top level directory of the output files. This can be
specified in place of \code{sfe} to directly read the transcript spot
coordinates from the file. When reading from file, transcripts from this file
are plotted and argument \code{sample_id} is ignored.}

\item{tech}{Name of the commercial technology, must be one of Vizgen, Xenium,
and CosMX.}

\item{file}{File (not GeoParquet) with numeric columns for xy coordinates of
the transcript spots. Ignored if \code{data_dir} is specified.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{bins}{Number of bins. Can be a vector of length 2 to specify for x and
y axes separately.}

\item{binwidth}{Width of bins, passed to \code{\link{geom_bin2d}} or
\code{\link{geom_hex}}.}

\item{hex}{Logical, whether to use hexagonal bins.}

\item{ncol}{Number of columns if plotting multiple features. Defaults to
\code{NULL}, which means using the same logic as \code{facet_wrap}, which
is used by \code{patchwork}'s \code{\link{wrap_plots}} by default.}

\item{bbox}{A bounding box to specify a smaller region to plot, useful when
the dataset is large. Can be a named numeric vector with names "xmin",
"xmax", "ymin", and "ymax", in any order. If plotting multiple samples, it
should be a matrix with sample IDs as column names and "xmin", "ymin",
"xmax", and "ymax" as row names. If multiple samples are plotted but
\code{bbox} is a vector rather than a matrix, then the same bounding box
will be used for all samples. You may see points at the edge of the
geometries if the intersection between the bounding box and a geometry
happens to be a point there. If \code{NULL}, then the entire tissue is
plotted.}

\item{gene}{Character vector of names of genes to plot. If "all" then
transcript spots of all genes are plotted.}

\item{spatialCoordsNames}{Column names for the x, y, and optionally z
coordinates of the spots. The defaults are for Vizgen.}

\item{gene_col}{Column name for genes.}

\item{rowGeometryName}{Name of a \code{rowGeometry} of the SFE object to
plot.}

\item{flip}{Logical, whether to flip the y axis when plotting data from file.}

\item{tx_file}{File path to GeoParquet file of the transcript spots if you
don't wish to load all transcript spots into the SFE object. See
\code{\link{formatTxSpots}} on generating such a GeoParquet file.}
}
\value{
A ggplot object, facetting by sample.
}
\description{
Plot transcript spot density as 2D histogram
}
