% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-non-spatial.R
\name{plotDimLoadings}
\alias{plotDimLoadings}
\title{Plot top PC loadings of genes}
\usage{
plotDimLoadings(
  sce,
  dims = 1:4,
  nfeatures = 10,
  swap_rownames = NULL,
  reduction = "PCA",
  balanced = TRUE,
  ncol = 2,
  sample_id = "all"
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object, or anything that inherits
from \code{SingleCellExperiment}.}

\item{dims}{Numeric vector specifying which PCs to plot. For MULTISPATI, PCs
with negative eigenvalues are in the right most columns of the embedding and
loading matrices. See the \code{\link{ElbowPlot}}.}

\item{nfeatures}{Number of genes to plot.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}

\item{reduction}{Name of the dimension reduction to use. It must have an
attribute called either "percentVar" or "eig" for eigenvalues. Defaults to
"PCA".}

\item{balanced}{Return an equal number of genes with + and - scores. If
FALSE, returns the top genes ranked by the scores absolute values.}

\item{ncol}{Number of columns in the facetted plot.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}
}
\value{
A ggplot object. Loadings for different PCs are plotted in different
  facets so one ggplot object is returned.
}
\description{
Just like Seurat's VizDimLoadings function. I haven't found an equivalent for
SCE but find it useful. But I'm not trying to reproduce that Seurat function
exactly. For instance, I don't like it when Seurat imposes a ggplot theme,
and I don't like the cowplot theme. Maybe I should rewrite it in base R but
for now I'm using Tidyverse.
}
\examples{
library(SFEData)
library(scater)
sfe <- McKellarMuscleData("small")
sfe <- runPCA(sfe, ncomponents = 10, exprs_values = "counts")
plotDimLoadings(sfe, dims = 1:2)
}
