% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_table.R
\name{show_table}
\alias{show_table}
\alias{show_table,ANY-method}
\title{Display an interactive or static table.}
\usage{
show_table(object, file = NULL)

\S4method{show_table}{ANY}(object, file = NULL)
}
\arguments{
\item{object}{an \code{\link{enrich_GO_terms-class}} object from \code{\link{merge_enrich_terms}},
or \code{\link{GO_clusters-class}} object from \code{\link{GOterms_heatmap}}.}

\item{file}{table output file name (default to NULL).}
}
\value{
display or print table
}
\description{
This method is used to display or print the table for \code{\link{enrich_GO_terms-class}} or \code{\link{GO_clusters-class}} objects.
}
\details{
This method displays an interactive table (if file=NULL) from \code{\link{enrich_GO_terms-class}} or \code{\link{GO_clusters-class}} objects.\cr
The table could be printed by setting file argument.
}
\examples{
# load example object
data(
    myGOs,
    package="ViSEAGO"
)

# display merge_enrich_terms output
ViSEAGO::show_table(myGOs)

# print merge_enrich_terms output
ViSEAGO::show_table(
    myGOs,
    "myGOs.txt"
)

\dontrun{
# compute GO terms Semantic Similarity distances
myGOs<-ViSEAGO::compute_SS_distances(
    distance="Wang"
)

# GOtermsHeatmap with default parameters
Wang_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Wang",
            aggreg.method="ward.D2",
            rotate=NULL
        ),
        cut=list(
            dynamic=list(
                pamStage=TRUE,
                pamRespectsDendro=TRUE,
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# display table of GO_clusters-class object
ViSEAGO::show_table(Wang_clusters_wardD2)

# print table of GO_clusters-class object
ViSEAGO::show_table(
    Wang_clusters_wardD2,
    "Wang_clusters_wardD2.txt"
)
}
}
\references{
Yihui Xie (2016). DT: A Wrapper of the JavaScript Library 'DataTables'. R package version 0.2. https://CRAN.R-project.org/package=DT
}
\seealso{
Other enrich_GO_terms: 
\code{\link{Upset}()},
\code{\link{enrich_GO_terms-class}},
\code{\link{overLapper}()},
\code{\link{show_heatmap}()}

Other GO_clusters: 
\code{\link{GO_clusters-class}},
\code{\link{GOclusters_heatmap}()},
\code{\link{clusters_cor}()},
\code{\link{compare_clusters}()},
\code{\link{show_heatmap}()}

Other visualization: 
\code{\link{GOclusters_heatmap}()},
\code{\link{GOcount}()},
\code{\link{GOterms_heatmap}()},
\code{\link{Upset}()},
\code{\link{available_organisms}()},
\code{\link{overLapper}()},
\code{\link{show_heatmap}()}
}
\concept{GO_clusters}
\concept{enrich_GO_terms}
\concept{visualization}
