% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_GO_SS.R
\name{build_GO_SS}
\alias{build_GO_SS}
\alias{build_GO_SS,gene2GO,enrich_GO_terms-method}
\title{build GO Semantic Similarity object.}
\usage{
build_GO_SS(gene2GO, enrich_GO_terms)

\S4method{build_GO_SS}{gene2GO,enrich_GO_terms}(gene2GO, enrich_GO_terms)
}
\arguments{
\item{gene2GO}{a \code{\link{gene2GO-class}} object from \code{\link{annotate}} method.}

\item{enrich_GO_terms}{a \code{\link{enrich_GO_terms-class}} from \code{\link{merge_enrich_terms}} method.}
}
\value{
a \code{\link{GO_SS-class}} object required by \code{\link{compute_SS_distances}}.
}
\description{
Compute the Information content (IC) on the given ontology, and
create a \code{\link{GO_SS-class}} object required by \code{\link{compute_SS_distances}} method to compute GO semantic similarity
between enriched GO terms or groups of terms.
}
\details{
This method use \code{\link{annotate}} and \code{\link{merge_enrich_terms}} output objects (see Arguments),
and compute the Information content (IC) using the internal code of \code{\link[GOSemSim]{godata}} function from \pkg{GOSemSim} package.
}
\examples{
\dontrun{
# initialyse object for compute GO Semantic Similarity
myGOs<-ViSEAGO::build_GO_SS(
    myGENE2GO,
    BP_sResults
)
}
# load data example
utils::data(
    myGOs,
    package="ViSEAGO"
)
}
\references{
Alexa A, Rahnenfuhrer J, Lengauer T. Improved scoring of functional groups from gene expression data by
decorrelating GO graph structure. Bioinformatics 2006; 22:1600-1607.

Guangchuang Yu, Fei Li, Yide Qin, Xiaochen Bo, Yibo Wu and Shengqi Wang. GOSemSim: an R package for measuring semantic similarity
among GO terms and gene products. Bioinformatics 2010 26(7):976-978.

Herve Pages, Marc Carlson, Seth Falcon and Nianhua Li (2017). AnnotationDbi: Annotation Database Interface. R package version 1.38.0.
}
\seealso{
Other GO_semantic_similarity: 
\code{\link{GO_SS-class}},
\code{\link{compute_SS_distances}()}
}
\concept{GO_semantic_similarity}
