% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{annotate}
\alias{annotate}
\alias{annotate,character,genomic_ressource-method}
\title{Retrieve GO annotations for a specie from genomic ressource database.}
\usage{
annotate(id, object, ortholog = FALSE)

\S4method{annotate}{character,genomic_ressource}(id, object, ortholog = FALSE)
}
\arguments{
\item{id}{identifiant corresponding to the organism of interest.
This id name is referenced in the first column of the database
used (see \code{\link{available_organisms}}).}

\item{object}{a required \code{\link{genomic_ressource-class}} object created by
\code{\link{Bioconductor2GO}}, \code{\link{EntrezGene2GO}},
\code{\link{Ensembl2GO}}, or \code{\link{Uniprot2GO}} methods.}

\item{ortholog}{\code{logical} (default to FALSE). Only available for
vertebrates organisms and for object created by \code{\link{EntrezGene2GO}} method (see Details).}
}
\value{
\code{annotate} produces an object of \code{\link{gene2GO-class}} required by \code{\link{build_GO_SS}} method.
}
\description{
This method retrieves and stores GO annotations for the
organism of interest from one of genomic ressource database
(Bioconductor, EntrezGene, Ensembl, Uniprot).
}
\details{
This method uses a \code{\link{genomic_ressource-class}} object to retrieve
\href{http://www.geneontology.org/page/ontology-documentation}{GO} annotations for the organism of interest.
The stored annotations are structured in 3 slots corresponding to the 3 GO categories: MF (Molecular Function),
BP (Biological Process), and CC (Cellular Component). Each slot contains GO terms with
associated \href{http://www.geneontology.org/page/guide-go-evidence-codes}{evidence code}.

The \code{\link{genomic_ressource-class}} object is created by one of the four available methods:
\code{\link{Bioconductor2GO}}, \code{\link{EntrezGene2GO}},
\code{\link{Ensembl2GO}}, or \code{\link{Uniprot2GO}}.

In the case of vertebrates, setting \code{ortholog} argument to \code{TRUE} is required if you need to add GO terms with experimental
\href{http://geneontology.org/page/guide-go-evidence-codes}{evidence codes} from orthologs genes
when using \code{\link{EntrezGene2GO}} method. To display organisms supported by NCBI EntrezGene orthologs pipeline,
set the arguments \code{id=NULL} and \code{ortholog=TRUE}.
This approch is highly similar to the strategy developed by Uniprot-GOA consortium for the Electronic Annotation Method using
\href{http://www.ebi.ac.uk/GOA/compara_go_annotations}{Ensembl Compara}.
}
\examples{
\dontrun{
## load Mus musculus (mouse) GO annotations

# from Bioconductor
Bioconductor<-ViSEAGO::Bioconductor2GO()
myGENE2GO<-ViSEAGO::annotate(
    id="org.Mm.eg.db",
    object=Bioconductor
)

# from EntrezGene
EntrezGene<-ViSEAGO::EntrezGene2GO()
myGENE2GO<-ViSEAGO::annotate(
    id="10090",
    object=EntrezGene
)

# from EntrezGene
Ensembl<-ViSEAGO::Ensembl2GO()
myGENE2GO<-ViSEAGO::annotate(
    id="mmusculus_gene_ensembl",
    object=Ensembl
)

# from Uniprot
Uniprot<-ViSEAGO::Uniprot2GO()
myGENE2GO<-ViSEAGO::annotate(
    id="mouse",
    object=Uniprot
)

## from Custom GO annotation file
Custom<-ViSEAGO::Custom2GO(system.file("extdata/customfile.txt",package = "ViSEAGO"))
myGENE2GO<-ViSEAGO::annotate(
    id="myspecies1",
    object=Custom
)

## specific options for EntrezGene database

# Chicken GO annotations without adding orthologs
EntrezGene<-ViSEAGO::EntrezGene2GO()
myGENE2GO<-ViSEAGO::annotate(
    id="9031",
    object=EntrezGene
)

# Chicken GO annotation with the add of orthologs GO annotations
EntrezGene<-ViSEAGO::EntrezGene2GO()
myGENE2GO<-ViSEAGO::annotate(
    id="9031",
    object=EntrezGene,
    ortholog=TRUE
)

# display organisms supported by NCBI EntrezGene orthologs pipeline
EntrezGene<-ViSEAGO::EntrezGene2GO()
ViSEAGO::annotate(
    id="NULL",
    object=EntrezGene,
    ortholog=TRUE
)
}
}
\references{
Durinck S, Spellman P, Birney E and Huber W (2009). Mapping identifiers for the integration of genomic datasets with the R/Bioconductor
package biomaRt. Nature Protocols, 4, pp. 1184-1191.

Durinck S, Moreau Y, Kasprzyk A, Davis S, De Moor B, Brazma A and Huber W (2005).
BioMart and Bioconductor: a powerful link between biological databases and microarray data analysis. Bioinformatics, 21, pp. 3439-3440.

Fong, JH, Murphy, TD, Pruitt, KD (2013). Comparison of RefSeq protein-coding regions in human and vertebrate genomes. BMC Genomics, 14:654.

Henrik Bengtsson (2016). R.utils: Various Programming Utilities. R package version 2.5.0. https://CRAN.R-project.org/package=R.utils.

Herve Pages, Marc Carlson, Seth Falcon and Nianhua Li (2017). AnnotationDbi: Annotation Database Interface. R package version 1.38.0.

Matt Dowle and Arun Srinivasan (2017). data.table: Extension of data.frame. R package version 1.10.4. https://CRAN.R-project.org/package=data.table.
}
\seealso{
Other genomic_ressource: 
\code{\link{Bioconductor2GO}()},
\code{\link{Custom2GO}()},
\code{\link{Ensembl2GO}()},
\code{\link{EntrezGene2GO}()},
\code{\link{Uniprot2GO}()},
\code{\link{available_organisms}()},
\code{\link{genomic_ressource-class}},
\code{\link{taxonomy}()}

Other GO_terms: 
\code{\link{GOcount}()},
\code{\link{GOterms_heatmap}()},
\code{\link{create_topGOdata}()},
\code{\link{gene2GO-class}},
\code{\link{merge_enrich_terms}()},
\code{\link{runfgsea}()}
}
\concept{GO_terms}
\concept{genomic_ressource}
