% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOclusters_heatmap.R
\name{GOclusters_heatmap}
\alias{GOclusters_heatmap}
\alias{GOclusters_heatmap,GO_clusters,list-method}
\title{Build a clustering heatmap on GO groups.}
\usage{
GOclusters_heatmap(
  object,
  tree = list(distance = "BMA", aggreg.method = "ward.D2", rotate = NULL)
)

\S4method{GOclusters_heatmap}{GO_clusters,list}(
  object,
  tree = list(distance = "BMA", aggreg.method = "ward.D2", rotate = NULL)
)
}
\arguments{
\item{object}{a  \code{\link{GO_clusters-class}} object from \code{\link{compute_SS_distances}}.}

\item{tree}{a named list with:
\describe{
    \item{distance ("BMA" by default)}{
    distance computed from the semantic similarity for GO groups which could be "max", "avg", "rcmax",or "BMA".}
    \item{aggreg.method ("ward.D2" by default)}{aggregation method criteria from \code{\link[stats]{hclust}} (ward.D",
    "ward.D2", "single", "complete", "average", "mcquitty", "median", or "centroid") to build a \code{dendrogram}.}
    \item{rotate}{sort the branches of the tree based on a vector - eithor of labels order or the labels in their new order}
}}
}
\value{
a \code{\link{GO_clusters-class}} object.
}
\description{
This method computes a clustering heatmap based on GO groups semantic similarity.
}
\details{
This method computes a clustering heatmap based on GO groups semantic similarity (computed with \code{\link{compute_SS_distances}}).\cr
The heatmap color intensity corresponds to the number of GO terms in each GO group.\cr
GO group description is defined as the first common GO ancestor with the cluster identifiant in brackets.\cr
The dendrogram branches are colored according to GO terms clusters.
}
\examples{
# load data example
utils::data(
    myGOs,
    package="ViSEAGO"
)
\dontrun{
# compute GO terms Semantic Similarity distances
myGOs<-ViSEAGO::compute_SS_distances(
    myGOs,
    distance="Wang"
)

# GOtermsHeatmap with default parameters
Wang_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Wang",
            aggreg.method="ward.D2",
            rotate=NULL
        ),
        cut=list(
            dynamic=list(
                pamStage=TRUE,
                pamRespectsDendro=TRUE,
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# compute clusters of GO terms Semantic Similarity distances
Wang_clusters_wardD2<-ViSEAGO::compute_SS_distances(
    Wang_clusters_wardD2,
    distance="BMA"
)

# GOclusters heatmap
Wang_clusters_wardD2<-ViSEAGO::GOclusters_heatmap(
    Wang_clusters_wardD2,
    tree=list(
        distance="BMA",
        aggreg.method="ward.D2",
        rotate=NULL
    )
)
}
}
\references{
Matt Dowle and Arun Srinivasan (2017). data.table: Extension of `data.frame`. R package version 1.10.4. https://CRAN.R-project.org/package=data.table.

Tal Galili (2015). dendextend: an R package for visualizing, adjusting, and comparing trees of hierarchical clustering.
Bioinformatics. DOI:10.1093/bioinformatics/btv428.

Tal Galili (2017). heatmaply: Interactive Cluster Heat Maps Using 'plotly'.
R package version 0.9.1. https://CRAN.R-project.org/package=heatmaply.

Erich Neuwirth (2014). RColorBrewer: ColorBrewer Palettes. R package version 1.1-2. https://CRAN.R-project.org/package=RColorBrewer.

Carson Sievert, Chris Parmer, Toby Hocking, Scott Chamberlain, Karthik Ram, Marianne Corvellec and Pedro Despouy (2017).
plotly: Create Interactive Web Graphics via 'plotly.js'. R package version 4.6.0. https://CRAN.R-project.org/package=plotly.

H. Wickham. ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York, 2009.
}
\seealso{
Other GO_clusters: 
\code{\link{GO_clusters-class}},
\code{\link{clusters_cor}()},
\code{\link{compare_clusters}()},
\code{\link{show_heatmap}()},
\code{\link{show_table}()}

Other visualization: 
\code{\link{GOcount}()},
\code{\link{GOterms_heatmap}()},
\code{\link{Upset}()},
\code{\link{available_organisms}()},
\code{\link{overLapper}()},
\code{\link{show_heatmap}()},
\code{\link{show_table}()}
}
\concept{GO_clusters}
\concept{semantic_similarity}
\concept{visualization}
