% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ensembl2GO.R
\name{Ensembl2GO}
\alias{Ensembl2GO}
\title{Check available organisms datasets at Ensembl.}
\usage{
Ensembl2GO(biomart = "genes", GRCh = NULL, version = NULL)
}
\arguments{
\item{biomart}{the biomart name available with \pkg{biomaRt} package \code{\link[biomaRt]{listEnsembl}} ("genes", the default) or \code{\link[biomaRt]{listEnsemblGenomes}} ("protists_mart", "fungi_mart", "plants_mart").}

\item{GRCh}{GRCh version to connect to if not the current GRCh38, currently this can only be 37}

\item{version}{the annotation version to use (eg. NULL for the default current version, or a version number in \code{character})}
}
\value{
a  \code{\link{genomic_ressource-class}} object required by \code{\link{annotate}}.
}
\description{
List Ensembl referenced organisms datasets from the current (NULL) or archive (number in \code{character}) annotation version.
}
\details{
This function gives referenced organisms genomes at \href{http://ensemblgenomes.org/}{Ensembl}.
It uses the \code{\link[biomaRt]{useEnsembl}} and  \code{\link[biomaRt]{listDatasets}} from \pkg{biomaRt} package.
}
\examples{
\dontrun{
# check the Ensembl available biomart (if not known)
biomaRt::listEnsembl()

# List Ensembl available organisms
Ensembl<-ViSEAGO::Ensembl2GO(
 biomart="genes",
 GRCh = NULL,
 version=NULL
)
}
}
\references{
Durinck S, Spellman P, Birney E and Huber W (2009).
Mapping identifiers for the integration of genomic datasets with the R/Bioconductor package biomaRt.
Nature Protocols, 4, pp. 1184-1191.

Durinck S, Moreau Y, Kasprzyk A, Davis S, De Moor B, Brazma A and Huber W (2005).
BioMart and Bioconductor: a powerful link between biological databases and microarray data analysis. Bioinformatics, 21, pp. 3439-3440.

Matt Dowle and Arun Srinivasan (2017). data.table: Extension of data.frame. R package version 1.10.4. https://CRAN.R-project.org/package=data.table.
}
\seealso{
Other genomic_ressource: 
\code{\link{Bioconductor2GO}()},
\code{\link{Custom2GO}()},
\code{\link{EntrezGene2GO}()},
\code{\link{Uniprot2GO}()},
\code{\link{annotate}()},
\code{\link{available_organisms}()},
\code{\link{genomic_ressource-class}},
\code{\link{taxonomy}()}
}
\concept{genomic_ressource}
