% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/vennpie.R
\name{vennpie}
\alias{vennpie}
\title{Create a Venn-pie visualization}
\usage{
vennpie(
  object,
  subset = NULL,
  top = 31,
  min = 0,
  color = NULL,
  revcolor = "lightgrey",
  any = NULL,
  show.number = TRUE,
  show.x = TRUE,
  sep = "_",
  log = FALSE,
  base = NULL,
  percentage = FALSE,
  title = NULL,
  interactive = FALSE,
  ...
)

\S4method{vennpie}{Venn}(
  object,
  subset = NULL,
  top = 31,
  min = 0,
  color = NULL,
  revcolor = "lightgrey",
  any = NULL,
  show.number = TRUE,
  show.x = TRUE,
  sep = "_",
  log = FALSE,
  base = NULL,
  percentage = FALSE
)
}
\arguments{
\item{object}{Venn object}

\item{subset}{Character vector giving the subset users want to highlight.}

\item{top}{number of subsets with largest to display (default: 31)}

\item{min}{The minimum number of input groups that a subset must belong to
e.g. min = 2 will only report those
subsets with elements shared by 2 or more input groups.}

\item{color}{Character vector giving the colors of the subsets.}

\item{revcolor}{Character giving the color for the non-selected subsets.}

\item{any}{Number to indicate selected subsets, such as 1 means any unique
subsets, 2 means any subsets shared by two groups.}

\item{show.number}{Boolean indicating whether to display the element numbers
of the subsets or not (default: TRUE).}

\item{show.x}{Boolean indicating whether to show subset labels outside the
circle (default: TRUE).}

\item{sep}{Character string used to separate the terms when concatenating
group names into new column names (colnames).}

\item{log}{Boolean indicating whether to transform the data in log scale .}

\item{base}{Base value for log transformation.}

\item{percentage}{Boolean indicating whether to display subset percentages
(default: FALSE).}

\item{title}{Optional plot title}

\item{interactive}{Logical: create interactive plot?}

\item{...}{Additional arguments}
}
\value{
A ggplot2 or plotly object

vennpie figure
}
\description{
Creates a pie-chart-like visualization of set intersections

Vennpie uses the venn object and to creates a figure in the
form of a venn pie diagram
rather than a traditional venn diagram. Users can highlight a specific
sections of the venn pie.
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
vennpie(res)
}
\author{
Kai Guo
}
