% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showAvailable.R
\name{showAvailable}
\alias{showAvailable}
\title{ShowAvailable}
\usage{
showAvailable(
  file,
  args = c("assayNames", "rowDataColumns", "colDataColumns", "infoColumns"),
  ftnode,
  smpnode
)
}
\arguments{
\item{file}{the path to the gds.class file.}

\item{args}{the arguments in \code{makeVariantExperimentFromGDS}.}

\item{ftnode}{the node name for feature id (e.g., "variant.id",
"snp.id", etc.). Must be provided if the file format is not
\code{SNP_ARRAY} or \code{SEQ_ARRAY}.}

\item{smpnode}{the node name for sample id (e.g.,
"sample.id"). Must be provided if the file format is not
\code{SNP_ARRAY} or \code{SEQ_ARRAY}.}
}
\description{
The function to show the available entries for the arguments within
\code{makeVariantExperimentFromGDS}
}
\examples{
## snp gds file
gds <- SNPRelate::snpgdsExampleFileName()
showAvailable(gds)

## sequencing gds file
gds <- SeqArray::seqExampleFileName("gds")
showAvailable(gds)

}
