% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runVDJPCA.R
\name{runVDJPCA}
\alias{runVDJPCA}
\alias{runVDJPCA,clonoStats-method}
\title{Run PCA on clonotype abundance matrix}
\usage{
runVDJPCA(x, ...)

\S4method{runVDJPCA}{clonoStats}(x, unit = c("samples", "clonotypes"))
}
\arguments{
\item{x}{A matrix of abundance values where rows are features (clonotypes)
and columns are samples.}

\item{...}{additional arguments.}

\item{unit}{Character value indicating whether the unit of interest is
\code{"samples"} or \code{"clonotypes"}.}
}
\value{
A list with class \code{"prcomp"}. The component \code{x} stores the
reduced-dimensional representation of the data. For a full description, see
\code{\link[stats]{prcomp}}.
}
\description{
Perform Principal Components Analysis (PCA) on the matrix of
sample-level clonotype abundances. In the context of clonotype analysis,
this is a form of beta diversity.
}
\examples{
data('contigs')
x <- clonoStats(contigs)
runVDJPCA(x)

}
