% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCFArray-classes.R
\docType{methods}
\name{extract_array}
\alias{extract_array}
\alias{extract_array,VCFArraySeed-method}
\alias{VCFArray-class}
\alias{matrixClass,VCFArray-method}
\alias{VCFMatrix}
\alias{VCFMatrix-class}
\alias{coerce}
\alias{coerce,VCFArray,VCFMatrix-method}
\alias{coerce,VCFMatrix,VCFArray-method}
\alias{coerce,ANY,VCFMatrix-method}
\alias{VCFArray}
\alias{VCFArray-method}
\title{VCFArray constructor and coercion methods.}
\usage{
\S4method{extract_array}{VCFArraySeed}(x, index)

VCFArray(file, vindex = character(), name = NA, pfix = NULL)
}
\arguments{
\item{x}{the VCFArraySeed object}

\item{index}{in \code{extract_array()}, an unnamed list of
subscripts as positive integer vectors, one vector per
dimension in \code{x}. Empty and missing subscripts
(represented by \code{integer(0)} and \code{NULL} list
elements, respectively) are allowed. The subscripts can contain
duplicated indices. They cannot contain NAs or non-positive
values.}

\item{file}{takes values for charater string (specifying the VCF
file path), \code{VcfFile} object, and \code{RangedVcfStack}
object.}

\item{vindex}{in \code{VCFArray()}, the character string specifying
the index file path. This argument is required if an remote VCF
file is used for the \code{file} argument.}

\item{name}{the data entry from VCF file to be read into
VCFArraySeed / VCFArray. For \code{VCFArray}. This argument
should always be specified.}

\item{pfix}{the category that the \code{name} belongs to. Available
values are \code{fixed}, \code{info}, and \code{info}. Can also
Check \code{vcfFields(file)} for matching \code{name} and
\code{pfix}.}
}
\value{
\code{VCFArray} class object.
}
\description{
\code{extract_array}: the function to extract data
    from a \code{VCF} file, by taking \code{VCFArraySeed} as
    input. This function is required by the \code{DelayedArray} for
    the seed contract.

\code{VCFArray}: The function to convert data entries
    inside VCF file into the \code{VCFArray} instance.
}
\examples{
fl <- system.file("extdata", "chr22.vcf.gz",
                  package="VariantAnnotation")
va <- VCFArray(fl, name = "GT")
va
vcf <- VariantAnnotation::VcfFile(fl)
va1 <- VCFArray(vcf, name = "GT")
va1
all.equal(va, va1)
\dontrun{
## RangedVcfStack class
extdata <- system.file(package = "GenomicFiles", "extdata")
files <- dir(extdata, pattern="^CEUtrio.*bgz$", full=TRUE)[1:2]
names(files) <- sub(".*_([0-9XY]+).*", "\\\\1", basename(files))
seqinfo <- as(readRDS(file.path(extdata, "seqinfo.rds")), "Seqinfo")
stack <- GenomicFiles::VcfStack(files, seqinfo)
gr <- as(GenomicFiles::seqinfo(stack)[rownames(stack)], "GRanges")
## RangedVcfStack
rgstack <- GenomicFiles::RangedVcfStack(stack, rowRanges = gr)
rgstack
va2 <- VCFArray(rgstack, name = "SB")
va2
}
## coercion
as(va[1:10, ], "array")
}
