% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parse_COSMIC_CCLE_CCLs.R
\name{initiate_canonical_databases}
\alias{initiate_canonical_databases}
\title{initiate_canonical_databases}
\usage{
initiate_canonical_databases(
    cosmic_file = "CosmicCLP_MutantExport.tsv.gz",
    ccle_file = "CCLE_mutations.csv",
    ccle_sample_file = "sample_info.csv",
    ref_gen = "GRCH38"
)
}
\arguments{
\item{cosmic_file}{The path to the Cosmic CLP file. The Cosmic file 
can be obtained from "https://cancer.sanger.ac.uk/cell_lines/download" and 
should be labeled "CosmicCLP_MutantExport.tsv.gz".
Ensure that the right reference genome is used}

\item{ccle_file}{The path to the ccle DNA genotype data file. 
It should be labeled "CCLE_mutations.csv".
Ensure that the right reference genome is used}

\item{ccle_sample_file}{The path to the CCLE sample file.
It should be labeled "sample_info.csv" containing both the
DepMap ID and corresponding cell line name.}

\item{ref_gen}{Reference genome version}
}
\value{
Returns message if parsing process has succeeded
}
\description{
Parses data into r list variable
}
\examples{
initiate_canonical_databases(
    cosmic_file = "CosmicCLP_MutantExport.tsv.gz",
    ccle_file = "CCLE_mutations.csv",
    ccle_sample_file = "sample_info.csv",
    ref_gen = "GRCH38"
)
}
