% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcfCheck.R
\name{vcfCheck}
\alias{vcfCheck}
\title{Check quality parameters (optional) and change IDs.}
\usage{
vcfCheck(largeCollapsedVcf, father, mother, proband, check_quality = FALSE)
}
\arguments{
\item{largeCollapsedVcf}{The file in largeCollapsedVcf format.}

\item{father}{Name of the father's sample.}

\item{mother}{Name of the mother's sample.}

\item{proband}{Name of the proband's sample.}

\item{check_quality}{Optional argument. TRUE/FALSE. If quality parameters
want to be measured.
Default = FALSE}
}
\value{
largeCollapsedVcf (VariantAnnotation VCF format).
}
\description{
This function takes a VCF file and converts it into a largeCollapsedVcf
object using the VariantAnnotation package. It also rename the sample for
subsequent steps needed in UPDhmm package.
Additionally, it features an optional parameter, quality_check, which triggers warnings
when variants lack sufficient quality based on RD and GQ parameters in the input VCF.
}
\examples{
fl <- system.file("extdata", "test_het_mat.vcf.gz", package = "UPDhmm")
vcf <- VariantAnnotation::readVcf(fl)
processedVcf <-
   vcfCheck(vcf, proband = "Sample1", mother = "Sample3", father = "Sample2")

}
