% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateEvents.R
\name{calculateEvents}
\alias{calculateEvents}
\title{Calculate UPD events in trio VCFs.}
\usage{
calculateEvents(
  largeCollapsedVcf,
  hmm = NULL,
  field_DP = NULL,
  BPPARAM = BiocParallel::SerialParam(),
  verbose = FALSE
)
}
\arguments{
\item{largeCollapsedVcf}{The VCF file in the general format
(largeCollapsedVcf) with VariantAnnotation package. Previously edited with
\code{vcfCheck()} function from UPDhmm package.}

\item{hmm}{Default = \code{NULL}. If no arguments are added, the package
will use the default HMM already implemented, based on Mendelian
inheritance. If an optional HMM is desired, it should adhere to the
general HMM format from \code{HMM} package with the following elements inside
a list:
\enumerate{
\item The hidden state names in the "States" vector.
\item All possible observations in the "Symbols" vector.
\item Start probabilities of every hidden state in the "startProbs" vector.
\item Transition probabilities matrix between states in "transProbs".
\item Probabilities associated between every hidden state and all possible
observations in the "emissionProbs" matrix.
}}

\item{field_DP}{Default = \code{NULL}. Character string specifying which FORMAT field in the VCF
contains the read depth information to use in \code{addRatioDepth()}.
If \code{NULL} (default), the function will automatically try \code{"DP"} (standard depth)
or \code{"AD"} (allelic depths, summed across alleles).
Use this parameter if your VCF uses a non-standard field name for depth,
e.g. \code{field = "NR"} or \code{"field_DP"}.}

\item{BPPARAM}{Parallelization settings, passed to
\link[BiocParallel]{bplapply}.
By default \code{BiocParallel::SerialParam()} (serial execution).
To enable parallelization, provide a BiocParallel backend, e.g.
\code{BiocParallel::MulticoreParam(workers = min(2, parallel::detectCores()))}
or \code{BiocParallel::SnowParam(workers = 2)}.
Note: when running under R CMD check or Bioconductor build systems,
the number of workers may be automatically limited (usually less or equal to 2).}

\item{verbose}{Logical, default = \code{FALSE}.
If \code{TRUE}, progress messages will be printed during processing.}
}
\value{
A \code{data.frame} object containing all detected events in the provided trio.
If no events are found, the function will return an empty \code{data.frame}.
}
\description{
This function predicts the hidden states by applying the Viterbi algorithm
using the Hidden Markov Model (HMM) from the UPDhmm package. It takes the
genotypes of the trio as input and includes a final step to simplify the
results into blocks.
}
\examples{
file <- system.file(package = "UPDhmm", "extdata", "test_het_mat.vcf.gz")
vcf <- VariantAnnotation::readVcf(file)
processedVcf <- vcfCheck(vcf,
    proband = "NA19675", 
    mother = "NA19678",
    father = "NA19679"
)

# Run in serial mode (default)
res <- calculateEvents(processedVcf)

# Run in parallel with 2 cores
library(BiocParallel)
param <- MulticoreParam(workers = 2)
res_parallel <- calculateEvents(processedVcf, BPPARAM = param)
}
