% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statsUMI4C.R
\name{statsUMI4C}
\alias{statsUMI4C}
\title{Statistics UMI4C}
\usage{
statsUMI4C(wk_dir)
}
\arguments{
\item{wk_dir}{Working directory where to save the outputs generated by the
UMI-4c analysis.}
}
\value{
Returns a plot summarizing the main statistics of the processed
UMI-4C experiments found in \code{wk_dir}. Also, writes a file named
\code{stats_summary.txt} in \code{wk_dir/logs} that summarizes all the
values represented in the plot.
}
\description{
Creates a stats summary file and generates a summary plot describing
statistics for processed UMI-4C samples.
}
\examples{
statsUMI4C(wk_dir = system.file("extdata", "CIITA",
    package = "UMI4Cats"
))
stats <- read.delim(system.file("extdata", "CIITA", "logs", "stats_summary.txt",
    package = "UMI4Cats"
))
head(stats)
}
