% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callInteractions.R
\name{smoothMonotoneUMI4C}
\alias{smoothMonotoneUMI4C}
\title{Monotone smoothing of the DDS object VST counts}
\usage{
smoothMonotoneUMI4C(dds, alpha = 20, penalty = 0.1)
}
\arguments{
\item{dds}{DDS object as generated by \code{vstUMI4C} with the 
variance stabilized count values.}

\item{alpha}{Approximate number of fragments desired for every basis function
of the B-spline basis. \code{floor((max(number of fragments)) / alpha)} is 
passed to \code{create.bspline.basis} as nbasis argument. 4 is the minimum
allowed value. Default: 20.}

\item{penalty}{Amount of smoothing to be applied to the estimated functional 
parameter.  Default: 0.1.}
}
\value{
DDS object with monotone smoothed fit counts.
}
\description{
Takes the variance stabilized count values and calculates a symmetric
monotone fit for the distance dependency. The signal trend is fitted using 
the \href{https://CRAN.R-project.org/package=fda}{fda} package. The position 
information about the viewpoint have to be stored in the metadata as 
\code{metadata(dds)[['bait']]}.
}
\details{
This function computes the smoothing function for the VST values, based on
\href{https://CRAN.R-project.org/package=fda}{fda} package, and calculates a symmetric monotone fit counts for the distance dependency
}
