% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{u_stat}
\alias{u_stat}
\title{Calculate Mann Whitney U from a vector of ranks}
\usage{
u_stat(ranks_matrix, gene_idx, maxRank = 1500, sparse = FALSE)
}
\arguments{
\item{ranks_matrix}{A matrix of ranks}

\item{gene_idx}{A list of gene indices}

\item{maxRank}{Max number of features to include in ranking}

\item{sparse}{Whether the vector of ranks is in sparse format}
}
\value{
Normalized U statistic for the vector of ranks
}
\description{
Maximum sum of ranks, rank_sum_max: len_sig * max_Rank
Minimum sum of ranks, rank_sum_min: len_sig * (len_sig + 1)/2
Maximum U statistic, Umax: Maximum sum of ranks - Minimum sum of ranks
Minimum U statistic, Umin: 0
Normalized U statistic (0 to 1), Unorm: (U - Umin)/(Umax- Umin) = U/Umax
UCell score (0 to 1): 1 - Unorm
}
\details{
Any rank > maxRank is set to maxRank
}
