% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{calculate_Uscore}
\alias{calculate_Uscore}
\title{Calculate rankings and scores for query data and given signature set}
\usage{
calculate_Uscore(
  matrix,
  features,
  maxRank = 1500,
  chunk.size = 100,
  BPPARAM = NULL,
  ncores = 1,
  w_neg = 1,
  ties.method = "average",
  missing_genes = c("impute", "skip"),
  storeRanks = FALSE,
  force.gc = FALSE,
  name = "_UCell"
)
}
\arguments{
\item{matrix}{Input data matrix}

\item{features}{List of signatures}

\item{maxRank}{Rank cutoff (1500)}

\item{chunk.size}{Cells per sub-matrix (100)}

\item{BPPARAM}{A BioParallel object to instruct UCell how to
parallelize}

\item{ncores}{Number of cores to use for parallelization}

\item{w_neg}{Weight on negative signatures}

\item{ties.method}{How to break ties, for data.table::frankv
method ("average")}

\item{missing_genes}{How to handle missing genes in matrix:
"impute": impute expression to zero; "skip": remove missing
genes from signature}

\item{storeRanks}{Store ranks? (FALSE)}

\item{force.gc}{Force garbage collection? (FALSE)}

\item{name}{Suffix for metadata columns ("_UCell")}
}
\value{
A list of signature scores
}
\description{
Calculate rankings and scores for query data and given signature set
}
