% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTSE.R
\name{makeTSE}
\alias{makeTSE}
\title{A toy TreeSummarizedExperiment object}
\usage{
makeTSE(nrow = 10, ncol = 4, include.rowTree = TRUE, include.colTree = TRUE)
}
\arguments{
\item{nrow}{a numeric value to specify the number of rows of
\code{TreeSummarizedExperiment}}

\item{ncol}{a numeric value to specify the number of columns of
\code{TreeSummarizedExperiment}}

\item{include.rowTree}{TRUE or FALSE. Default is TRUE, so the output
\code{TreeSummarizedExperiment} has a \code{phylo} object in
\code{rowTree}.}

\item{include.colTree}{TRUE or FALSE. Default is TRUE, so the output
\code{TreeSummarizedExperiment} has a \code{phylo} object in
\code{colTree}.}
}
\value{
A TreeSummarizedExperiment object
}
\description{
\code{makeTSE} creates a toy TreeSummarizedExperiment object.
}
\details{
The \code{assays} contains a matrix with values from
  \code{1:(nrow*ncol)}. The \code{rowData} has two columns, \code{var1} and
  \code{var2}. \code{var1} is created with \code{rep_len(letters, nrow)}.
  \code{var2} is created with \code{rep_len(c(TRUE, FALSE), nrow)}. The
  \code{colData} has two columns, \code{ID} and \code{group}. \code{ID} is
  created with \code{seq_len(ncol)}. \code{group} is created with
  \code{rep_len(LETTERS[1:2], ncol)}. The row/col tree is generated with
  \code{ape::rtree()}. So, to generate reproducible trees, \code{set.seed()}
  is required.
}
\examples{

set.seed(1)
makeTSE()
}
\author{
Ruizhu Huang
}
