% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specializedTransductionID.R
\name{specializedTransductionID}
\alias{specializedTransductionID}
\title{Identify potential specialized transduction events on contigs classified as
Prophage-like}
\usage{
specializedTransductionID(
  VLPpileup,
  TrIdentResults,
  specificContig,
  noReadCov = 500,
  specTransLength = 2000,
  logScale = FALSE,
  verbose = TRUE,
  SaveFilesTo
)
}
\arguments{
\item{VLPpileup}{VLP-fraction pileup file generated by mapping sequencing reads
from a sample's ultra-purified VLP-fraction mapped to the sample's whole-community
metagenome assembly. The pileup file MUST have the following format:
* V1: Contig accession
* V2: Mapped read coverage values averaged over 100 bp windows
* V3: Starting position (bp) of each 100 bp window. Restarts from 0 at the
start of each new contig.
* V4: Starting position (bp) of each 100 bp window. Does NOT restart at the
start of each new contig.}

\item{TrIdentResults}{Output from `TrIdentClassifier()`}

\item{specificContig}{Optional, Search a specific contig classified as
Prophage-like ("NODE_1").}

\item{noReadCov}{Number of basepairs of zero read coverage encountered before
specialized transduction searching stops. Default is 500. Must be at least
100.}

\item{specTransLength}{Number of basepairs of non-zero read coverage needed
for specialized transduction to be considered. Default is 2000. Must be
at least 100.}

\item{logScale}{TRUE or FALSE, display VLP-fraction read coverage in log10
scale. Default is FALSE.}

\item{verbose}{TRUE or FALSE. Print progress messages to console. Default is TRUE.}

\item{SaveFilesTo}{Provide a path to the directory you wish to save output
to. `specializedTransductionID()` will make a folder within the provided
directory to store results.}
}
\value{
Large list containing two objects
}
\description{
Search contigs classified as Prophage-like for dense read coverage outside of
the pattern-match borders that may indicate specialized transduction. Returns
a list with the first object containing a summary table and the second object
containing a list of plots of with associated specialzied transduction search
results. If the plot is green, it has been identified as having potential
specialized transduction.
}
\examples{
data("VLPFractionSamplePileup")
data("TrIdentSampleOutput")

specTransduction <- specializedTransductionID(
  VLPpileup = VLPFractionSamplePileup,
  TrIdentResults = TrIdentSampleOutput
)

specTransductionNODE62 <- specializedTransductionID(
  VLPpileup = VLPFractionSamplePileup,
  TrIdentResults = TrIdentSampleOutput,
  specificContig = "NODE_62"
)
}
