% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingTrIdentResultsFunctions.R
\name{plotTrIdentResults}
\alias{plotTrIdentResults}
\title{Plot read coverage graphs of contigs classified as Prophage-like, Sloping, or
HighCovNoPattern}
\usage{
plotTrIdentResults(
  VLPpileup,
  WCpileup,
  TrIdentResults,
  onlyPlot,
  logScale = FALSE,
  saveFilesTo
)
}
\arguments{
\item{VLPpileup}{VLP-fraction pileup file generated by mapping sequencing reads
from a sample's ultra-purified VLP-fraction mapped to the sample's whole-community
metagenome assembly. The pileup file MUST have the following format:
* V1: Contig accession
* V2: Mapped read coverage values averaged over 100 bp windows
* V3: Starting position (bp) of each 100 bp window. Restarts from 0 at the
start of each new contig.
* V4: Starting position (bp) of each 100 bp window. Does NOT restart at the
start of each new contig.}

\item{WCpileup}{A whole-community pileup file generated by mapping sequencing reads
from a sample's whole-community mapped to the sample's whole-community metagenome assembly.
The pileup file MUST have the following format:
* V1: Contig accession
* V2: Mapped read coverage values averaged over 100 bp windows
* V3: Starting position (bp) of each 100 bp window. Restarts from 0 at the
start of each new contig.
* V4: Starting position (bp) of each 100 bp window. Does NOT restart at the
start of each new contig.}

\item{TrIdentResults}{Output from `TrIdentClassifier()`.}

\item{onlyPlot}{Optional, use to 'only plot' the contigs classified as either 
"Prophage-like", "Sloping", or "HighCovNoPattern".}

\item{logScale}{TRUE or FALSE, display VLP-fraction read coverage in log10
scale. Default is FALSE.}

\item{saveFilesTo}{Optional, Provide a path to the directory you wish to save
output to. A folder will be made within the provided directory to store
results.}
}
\value{
Large list containing ggplot objects
}
\description{
Plot the read coverages of a contig and its associated pattern-match for
Prophage-like, Sloping and HighCovNoPattern classifications. Returns a list
of ggplot objects.
}
\examples{
data("VLPFractionSamplePileup")
data("WholeCommunitySamplePileup")
data("TrIdentSampleOutput")

patternMatches <- plotTrIdentResults(
  VLPpileup = VLPFractionSamplePileup,
  WCpileup = WholeCommunitySamplePileup,
  TrIdentResults = TrIdentSampleOutput
)
}
