% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToxicoSet-class.R
\docType{class}
\name{ToxicoSet-class}
\alias{ToxicoSet-class}
\alias{.ToxicoSet}
\title{Class to contain Toxico-genomic Data}
\value{
An object of the ToxicoSet class
}
\description{
The ToxicoSet (tSet) class was development to contain and organise large
ToxicGenomic datasets as well as provide useful tools for interacting with
this data. Functions are included for exploring the relationship between
survival fraction and gene expression in cultured human and rat tissues
during exposure to a wide ranges of compounds. Features include plotting dose
and exposure time curves, calculating AUC, fitting linear models and
computing sensitivity signatures.
}
\section{Slots}{

\describe{
\item{\code{annotation}}{A \code{list} of annotation data about the ToxicoSet,
including the \code{$name} and the session information for how the object
was creating, detailing the exact versions of R and all the packages used}

\item{\code{molecularProfiles}}{A \code{list} containing \code{SummarizedExperiment}
type object for holding data for RNA, DNA, SNP and CNV
measurements, with associated \code{fData} and \code{pData}
containing the row and column metadata}

\item{\code{sample}}{A \code{data.frame} containing the annotations for all the cell
lines profiled in the data set, across all data types}

\item{\code{treatment}}{A \code{data.frame} containg the annotations for all the drugs
profiled in the data set, across all data types}

\item{\code{treatmentResponse}}{A \code{list} containing all the data for the sensitivity
experiments, including \code{$info}, a \code{data.frame} containing the
experimental info,\code{$raw} a 3D \code{array} containing raw data,
\code{$profiles}, a \code{data.frame} containing sensitivity profiles
statistics, and \code{$n}, a \code{data.frame} detailing the number of
experiments for each cell-drug pair}

\item{\code{perturbation}}{A \code{list} containting \code{$n}, a \code{data.frame}
summarizing the available perturbation data,}

\item{\code{curation}}{A \code{list} containing mappings for \code{$treatment},
\code{sample}, \code{tissue} names  used in the data set to universal
identifiers used between different ToxicoSet objects}

\item{\code{datasetType}}{A \code{character} string of 'sensitivity',
'perturbation', or both detailing what type of data can be found in the
ToxicoSet, for proper processing of the data}
}}

