% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToxicoSet-accessors.R
\name{ToxicoSet-accessors}
\alias{ToxicoSet-accessors}
\alias{drugInfo}
\alias{treatmentInfo,ToxicoSet-method}
\alias{treatmentInfo}
\alias{drugInfo<-}
\alias{treatmentInfo<-,ToxicoSet,data.frame-method}
\alias{treatmentInfo<-}
\alias{drugNames}
\alias{treatmentNames,ToxicoSet-method}
\alias{treatmentNames}
\alias{drugNames<-}
\alias{treatmentNames<-,ToxicoSet,character-method}
\alias{treatmentNames<-}
\alias{annotation,ToxicoSet-method}
\alias{annotation}
\alias{annotation<-,ToxicoSet,list-method}
\alias{annotation<-}
\alias{dateCreated,ToxicoSet-method}
\alias{dateCreated}
\alias{dateCreated<-,ToxicoSet,character-method}
\alias{dateCreated<-,ToxicoSet-method}
\alias{dateCreated<-}
\alias{name,ToxicoSet-method}
\alias{name}
\alias{name<-,ToxicoSet-method}
\alias{name<-,ToxicoSet,character-method}
\alias{name<-}
\alias{sampleInfo,ToxicoSet-method}
\alias{sampleInfo}
\alias{cellInfo,ToxicoSet-method}
\alias{cellInfo}
\alias{sampleInfo<-,ToxicoSet,data.frame-method}
\alias{sampleInfo<-}
\alias{cellInfo<-,ToxicoSet,data.frame-method}
\alias{cellInfo<-}
\alias{sampleNames,ToxicoSet-method}
\alias{sampleName,ToxicoSet-method}
\alias{sampleNames}
\alias{cellName,ToxicoSet-method}
\alias{cellNames}
\alias{sampleNames<-,ToxicoSet,character-method}
\alias{sampleNames<-,ToxicoSet,list-method}
\alias{sampleNames<-}
\alias{cellNames<-,ToxicoSet,list-method}
\alias{cellNames<-}
\alias{curation,ToxicoSet-method}
\alias{curation}
\alias{curation<-,ToxicoSet,list-method}
\alias{curation<-}
\alias{datasetType,ToxicoSet-method}
\alias{datasetType}
\alias{datasetType<-,ToxicoSet,character-method}
\alias{datasetType<-}
\alias{molecularProfiles,ToxicoSet-method}
\alias{molecularProfiles}
\alias{molecularProfiles<-,ToxicoSet,character,character,matrix-method}
\alias{molecularProfiles<-,ToxicoSet,character,missing,matrix-method}
\alias{molecularProfiles<-,ToxicoSet,missing,missing,list-method}
\alias{molecularProfiles<-,ToxicoSet,missing,missing,MutliAssayExperiment-method}
\alias{molecularProfiles<-}
\alias{featureInfo,ToxicoSet-method}
\alias{featureInfo}
\alias{featureInfo<-,ToxicoSet,character,data.frame-method}
\alias{featureInfo<-,ToxicoSet,character,DataFrame-method}
\alias{featureInfo<-}
\alias{phenoInfo,ToxicoSet,character-method}
\alias{phenoInfo}
\alias{phenoInfo<-,ToxicoSet,character,data.frame-method}
\alias{phenoInfo<-,ToxicoSet,character,DataFrame-method}
\alias{phenoInfo<-}
\alias{fNames,ToxicoSet,character-method}
\alias{fNames}
\alias{fNames<-,ToxicoSet,character,character-method}
\alias{fNames<-}
\alias{mDataNames,ToxicoSet-method}
\alias{mDataNames}
\alias{mDataNames<-,ToxicoSet-method}
\alias{mDataNames<-,ToxicoSet,ANY-method}
\alias{mDataNames<-}
\alias{molecularProfilesSlot,ToxicoSet-method}
\alias{moleculerProfilesSlot,ToxicoSet-method}
\alias{molecularProfilesSlot}
\alias{molecularProfilesSlot<-,ToxicoSet,list_OR_MAE-method}
\alias{molecularProfilesSlot<-,ToxicoSet,list-method}
\alias{molecularProfilesSlot<-ToxicoSet,MultiAssayExperiment-method}
\alias{molecularProfilesSlot<-}
\alias{sensitivityInfo,ToxicoSet-method}
\alias{sensitivityInfo,ToxicoSet,missing-method}
\alias{sensitivityInfo,ToxicoSet,character-method}
\alias{sensitivityInfo<-,ToxicoSet,data.frame-method}
\alias{sensitivityInfo<-,ToxicoSet,missing,data.frame-method}
\alias{sensitvityInfo<-,ToxicoSet,character,data.frame-method}
\alias{sensitivityMeasures,ToxicoSet-method}
\alias{sensitivityMeasures<-,ToxicoSet,character-method}
\alias{sensitivityProfiles,ToxicoSet-method}
\alias{sensitivityProfiles<-,ToxicoSet,data.frame-method}
\alias{sensitivityRaw,ToxicoSet-method}
\alias{sensitivityRaw<-,ToxicoSet,array-method}
\alias{treatmentResponse,ToxicoSet-method}
\alias{treatmentResponse}
\alias{sensitivitySlot}
\alias{treatmentResponse<-,ToxicoSet,list_OR_LongTable-method}
\alias{treatmentResponse<-}
\alias{treamentResponse<-,ToxicoSet,list-method}
\alias{treatmentResponse<-,ToxicoSet,LongTable-method}
\alias{sensitivitySlot<-}
\alias{sensNumber,ToxicoSet-method}
\alias{sensNumber}
\alias{sensNumber<-,ToxicoSet,matrix-method}
\alias{sensNumber<-}
\alias{pertNumber,ToxicoSet-method}
\alias{pertNumber}
\alias{pertNumber<-,ToxicoSet,array-method}
\alias{pertNumber<-}
\title{Accessing and modifying information in a \code{CoreSet}}
\usage{
drugInfo(...)

drugInfo(...) <- value

drugNames(...)

drugNames(...) <- value

\S4method{annotation}{ToxicoSet}(object)

\S4method{annotation}{ToxicoSet,list}(object) <- value

\S4method{dateCreated}{ToxicoSet}(object)

\S4method{dateCreated}{ToxicoSet,character}(object) <- value

\S4method{name}{ToxicoSet}(object)

\S4method{name}{ToxicoSet}(object) <- value

\S4method{sampleInfo}{ToxicoSet}(object)

\S4method{sampleInfo}{ToxicoSet,data.frame}(object) <- value

\S4method{sampleNames}{ToxicoSet}(object)

\S4method{sampleNames}{ToxicoSet,character}(object) <- value

\S4method{curation}{ToxicoSet}(object)

\S4method{curation}{ToxicoSet,list}(object) <- value

\S4method{datasetType}{ToxicoSet}(object)

\S4method{datasetType}{ToxicoSet,character}(object) <- value

\S4method{molecularProfiles}{ToxicoSet}(object, mDataType, assay)

\S4method{molecularProfiles}{ToxicoSet,character,character,matrix}(object, mDataType, assay) <- value

\S4method{featureInfo}{ToxicoSet}(object, mDataType)

\S4method{featureInfo}{ToxicoSet,character,data.frame}(object, mDataType) <- value

\S4method{phenoInfo}{ToxicoSet,character}(object, mDataType)

\S4method{phenoInfo}{ToxicoSet,character,data.frame}(object, mDataType) <- value

\S4method{fNames}{ToxicoSet,character}(object, mDataType)

\S4method{fNames}{ToxicoSet,character,character}(object, mDataType) <- value

\S4method{mDataNames}{ToxicoSet}(object)

\S4method{mDataNames}{ToxicoSet}(object) <- value

\S4method{molecularProfilesSlot}{ToxicoSet}(object)

\S4method{molecularProfilesSlot}{ToxicoSet,list_OR_MAE}(object) <- value

\S4method{sensitivityInfo}{ToxicoSet}(object, dimension, ...)

\S4method{sensitivityInfo}{ToxicoSet,data.frame}(object, dimension, ...) <- value

\S4method{sensitivityMeasures}{ToxicoSet}(object)

\S4method{sensitivityMeasures}{ToxicoSet,character}(object) <- value

\S4method{sensitivityProfiles}{ToxicoSet}(object)

\S4method{sensitivityProfiles}{ToxicoSet,data.frame}(object) <- value

\S4method{sensitivityRaw}{ToxicoSet}(object)

\S4method{sensitivityRaw}{ToxicoSet,array}(object) <- value

\S4method{treatmentResponse}{ToxicoSet}(object)

\S4method{treatmentResponse}{ToxicoSet,list_OR_LongTable}(object) <- value

\S4method{sensNumber}{ToxicoSet}(object)

\S4method{sensNumber}{ToxicoSet,matrix}(object) <- value

\S4method{pertNumber}{ToxicoSet}(object)

\S4method{pertNumber}{ToxicoSet,array}(object) <- value
}
\arguments{
\item{...}{See details.}

\item{value}{See details.}

\item{object}{A \code{CoreSet} object.}

\item{mDataType}{\code{character(1)} The name of a molecular datatype to access
from the \code{molecularProfiles} of a \code{CoreSet} object.}

\item{assay}{\code{character(1)} A valid assay name in the \code{SummarizedExperiment}
of \verb{@molecularProfiles} of a CoreSet object for data type \code{mDataType}.}

\item{dimension}{See details.}
}
\value{
Accessors: See details.

Setters: An updated \code{CoreSet} object, returned invisibly.
}
\description{
Documentation for the various setters and getters which allow manipulation
of data in the slots of a \code{CoreSet} object.
}
\details{
\strong{treatmentInfo}: \code{data.frame} Metadata for all treatments in a \code{ToxicoSet}
object. Arguments:
\itemize{
\item object: \code{ToxicoSet} An object to retrieve treatment metadata from.
}

\strong{treatmentInfo<-}: \code{ToxicoSet} object with updated treatment metadata.
object. Arguments:
\itemize{
\item object: \code{ToxicoSet} An object to set treatment metadata for.
\item value: \code{data.frame} A new table of treatment metadata for \code{object}.
}

\strong{treatmentNames}: \code{character} Names for all treatments in a \code{ToxicoSet}
object. Arguments:
\itemize{
\item object: \code{ToxicoSet} An object to retrieve treatment names from.
}

\strong{treatmentNames<-}: \code{ToxicoSet} Object with updates treatment names.
object. Arguments:
\itemize{
\item object: \code{ToxicoSet} An object to set treatment names from.
\item value: \code{character} A character vector of updated treatment names.
}

\subsection{@annotation}{

\strong{annotation}: A \code{list} of ToxicoSet annotations with items: 'name',
the name of the object; 'dateCreated', date the object was created; 'sessionInfo',
the \code{sessionInfo()} when the object was created; 'call', the R constructor call;
and 'version', the object version.
}

\strong{annotation<-}: Setter method for the annotation slot. Arguments:
\itemize{
\item value: a \code{list} of annotations to update the ToxicoSet with.
}

\subsection{@dateCreated}{

\strong{dateCreated}: \code{character(1)} The date the \code{ToxicoSet} object was
created, as returned by the \code{date()} function.
}

\strong{dateCreated<-}: Update the 'dateCreated' item in the \code{annotation} slot of
a \code{ToxicoSet} object. Arguments:
\itemize{
\item value: A \code{character(1)} vector, as returned by the \code{date()} function.
}

\strong{name}: \code{character(1)} The name of the \code{ToxicoSet}, retreived from
the \verb{@annotation} slot.

\strong{name<-}: Update the \verb{@annotation$name} value in a \code{ToxicoSet}  object.
\itemize{
\item value: \code{character(1)} The name of the \code{ToxicoSet} object.
}

\strong{cellInfo}: \code{data.frame} Metadata for all sample in a \code{ToxicoSet} object.

\strong{sampleInfo<-}: assign updated sample annotations to the \code{ToxicoSet}
object.
Arguments:
\itemize{
\item value: a \code{data.frame} object.
}

\strong{sampleNames}: \code{character} Retrieve the rownames of the \code{data.frame} in
the \code{sample} slot from a ToxicoSet object.

\strong{sampleNames<-}: assign new rownames to the sampleInfo \code{data.frame} for
a ToxicoSet object.
Arguments:
\itemize{
\item value: \code{character} vector of rownames for the \code{sampleInfo(object)} \code{data.frame}.
}

\subsection{@curation}{

\strong{curation}: A \code{list} of curated mappings between identifiers in the
ToxicoSet object and the original data publication. Contains three \code{data.frame}s, 'cell' with
cell-line ids and 'tissue' with tissue ids and 'drug' with drug ids.
}

\strong{curation<-}: Update the \code{curation} slot of a ToxicoSet object. Arugments:
\itemize{
\item value: A \code{list} of \code{data.frame}s, one for each type of curated
identifier. For a \code{ToxicoSet} object the slot should
contain tissue, cell-line and drug id \code{data.frame}s.
}

\subsection{datasetType slot}{

\strong{datasetType}: \code{character(1)} The type treatment response in the
\code{sensitivity} slot. Valid values are 'sensitivity', 'perturbation' or 'both'.
}

\strong{datasetType<-}: Update the datasetType slot of a ToxicoSet object.
Arguments:
\itemize{
\item value: A \code{character(1)} vector with one of 'sensitivity', 'perturbation'
or 'both'
}

\subsection{@molecularProfiles}{

\strong{molecularProfiles}: \code{matrix()} Retrieve an assay in a
\code{SummarizedExperiment} from the \code{molecularProfiles} slot of a \code{ToxicoSet}
object with the specified \code{mDataType}. Valid \code{mDataType} arguments can be
found with \code{mDataNames(object)}. Exclude \code{mDataType} and \code{assay} to
access the entire slot. Arguments:
\itemize{
\item assay: Optional \code{character(1)} vector specifying an assay in the
\code{SummarizedExperiment} of the \code{molecularProfiles} slot of the
\code{ToxicoSet} object for the specified \code{mDataType}. If excluded,
defaults to modifying the first assay in the \code{SummarizedExperiment} for
the given \code{mDataType}.
}
}

\strong{molecularProfiles<-}: Update an assay in a \code{SummarizedExperiment} from
the \code{molecularProfiles} slot of a ToxicoSet object with the specified
\code{mDataType}. Valid \code{mDataType} arguments can be found with
\code{mDataNames(object)}. Omit \code{mDataType} and \code{assay} to update the slot.
\itemize{
\item assay: Optional \code{character(1)} vector specifying an assay in the
\code{SummarizedExperiment} of the \code{molecularProfiles} slot of the
\code{ToxicoSet} object for the specified \code{mDataType}. If excluded,
defaults to modifying the first assay in the \code{SummarizedExperiment} for
the given \code{mDataType}.
\item value: A \code{matrix} of values to assign to the \code{assay} slot of the
\code{SummarizedExperiment} for the selected \code{mDataType}. The rownames and
column names must match the associated \code{SummarizedExperiment}.
}

\strong{featureInfo}: Retrieve a \code{DataFrame} of feature metadata for the specified
\code{mDataType} from the \code{molecularProfiles} slot of a \code{ToxicoSet} object. More
specifically, retrieve the \verb{@rowData} slot from the \code{SummarizedExperiment}
from the \verb{@molecularProfiles} of a \code{ToxicoSet} object with the name
\code{mDataType}.

\strong{featureInfo<-}: Update the \code{featureInfo(object, mDataType)} \code{DataFrame}
with new feature metadata. Arguments:
\itemize{
\item value: A \code{data.frame} or \code{DataFrame} with updated feature metadata for
the specified molecular profile in the \code{molecularProfiles} slot of a
\code{ToxicoSet} object.
}

\strong{phenoInfo}: Return the \verb{@colData} slot from the \code{SummarizedExperiment} of
\code{mDataType}, containing sample-level metadata, from a \code{ToxicoSet} object.

\strong{phenoInfo<-}: Update the \verb{@colData} slot of the \code{SummarizedExperiment}
of \code{mDataType} in the \verb{@molecularProfiles} slot of a \code{ToxicoSet} object.
This updates the sample-level metadata in-place.
\itemize{
\item value: A \code{data.frame} or \code{DataFrame} object where rows are samples
and columns are sample metadata.
}

\strong{fNames}: \code{character()} The features names from the \code{rowData} slot of a
\code{SummarizedExperiment} of \code{mDataType} within a \code{ToxicoSet} object.

\strong{fNames}: Updates the rownames of the feature metadata (i.e., \code{rowData})
for a \code{SummarizedExperiment} of \code{mDataType} within a \code{ToxicoSet} object.
\itemize{
\item value: \code{character()} A character vector of new features names for the
\code{rowData} of the \code{SummarizedExperiment} of \code{mDataType} in the
\verb{@molecularProfiles} slot of a \code{ToxicoSet} object. Must be the same
length as \code{nrow(featureInfo(object, mDataType))},
the number of rows in the feature metadata.
}

\strong{mDataNames}: \code{character} Retrieve the names of the molecular data types
available in the \code{molecularProfiles} slot of a \code{ToxicoSet} object. These
are the options which can be used in the \code{mDataType} parameter of various
\code{molecularProfiles} slot accessors methods.

\strong{mDataNames}: Update the molecular data type names of the
\code{molecularProfiles} slot of a ToxicoSet object. Arguments:
\itemize{
\item value: \code{character} vector of molecular datatype names, with length
equal to \code{length(molecularProfilesSlot(object))}.
}

\strong{molecularProfilesSlot}: Return the contents of the \verb{@molecularProfiles}
slot of a \code{ToxicoSet} object. This will either be a \code{list} or
\code{MultiAssayExperiment} of \code{SummarizedExperiment}s.

\strong{molecularProfilesSlot<-}: Update the contents of the \verb{@molecularProfiles}
slot of a \code{ToxicoSet} object. Arguemnts:
\itemize{
\item value: A \code{list} or \code{MultiAssayExperiment} of \code{SummarizedExperiment}s. The
\code{list} and \code{assays} should be named for the molecular datatype in each
\code{SummarizedExperiment}.
}

\subsection{@treatmentResponse}{
\subsection{Arguments:}{
\itemize{
\item \code{dimension}: Optional \code{character(1)} One of 'treatment', 'sample' or
'assay' to retrieve \code{rowData}, \code{colData} or the 'assay_metadata' assay from
the \code{ToxicoSet} \verb{@sensitvity} \code{LongTable} object, respectively. Ignored with
warning if \verb{@treatmentResponse} is not a \code{LongTable} object.
\item \code{...}: Additional arguments to the \code{rowData} or \code{colData}.
\code{LongTable} methods. Only used if the sensitivity slot contains a
\code{LongTable} object instead of a \code{list} and the \code{dimension} argument is
specified.
}
}

\subsection{Methods:}{

\strong{sensitivityInfo}: \code{DataFrame} or \code{data.frame} of sensitivity treatment combo
by sample metadata for the \code{ToxicoSet} object. When the \code{dimension}
parameter is used, it allows retrieval of the dimension specific metadata
from the \code{LongTable} object in \verb{@treatmentResponse} of a ToxicoSet object.
}

}

\strong{sensitivityInfo}<-: Update the \verb{@treatmentResponse} slot metadata for a
\code{ToxicoSet} object. When used without the \code{dimension} argument is behaves
similar to the old ToxicoSet implementation, where the \verb{@treatmentResponse} slot
contained a list with a \verb{$info} \code{data.frame} item. When the \code{dimension}
arugment is used, more complicated assignments can occur where 'sample'
modifies the \verb{@sensitvity} \code{LongTable} colData, 'treatment' the rowData and
'assay' the 'assay_metadata' assay.
Arguments:
\itemize{
\item value: A \code{data.frame} of treatment response experiment metadata,
documenting experiment level metadata (mapping to treatments and samples). If
the \verb{@treatmentResponse} slot doesn't contain a \code{LongTable} and \code{dimension} is
not specified, you can only modify existing columns as returned by
\code{sensitivityInfo(object)}.
}

\strong{sensitivityMeaures}: Get the 'sensitivityMeasures' available in a \code{ToxicoSet}
object. Each measure reprents some summary of sample sensitivity to a given
treatment, such as ic50, ec50, AUC, AAC, etc. The results are returned as a
\code{character} vector with all available metrics for the PSet object.

\strong{sensitivityMeaures}: Update the sensitivity meaure in a \code{ToxicoSet}
object. Thesee values are the column names of the 'profiles' assay and
represent various compued sensitviity metrics such as ic50, ec50, AUC, AAC,
etc.
\itemize{
\item value: A \code{character} vector of new sensitivity measure names, the
then length of the character vector must matcht he number of columns of the
'profiles' assay, excluding metadata and key columns.
}

\strong{sensitivityProfiles}: Return the sensitivity profile summaries from the
sensitivity slot. This data.frame cotanins vaarious sensitivity summary
metrics, such as ic50, amax, EC50, aac, HS, etc as columns, with rows as
treatment by sample experiments.

\strong{sensitivityProfiles<-}: Update the sensitivity profile summaries the
sensitivity slot. Arguments:
-value: A \code{data.frame} the the same number of rows as as returned by
\code{sensitivityProfiles(object)}, but potentially modified columns, such as the
computation of additional summary metrics.

\strong{sensitivityRaw}: Access the raw sensitiity measurents for a ToxicoSet
object. A 3D \code{array} where rows are experiment_ids, columns are doses
and the third dimension is metric, either 'Dose' for the doses used or
'Viability' for the sample viability at that dose.

\strong{sensitvityRaw<-}: Update the raw dose and viability data in a \code{ToxicoSet}.
\itemize{
\item value: A 3D \code{array} object where rows are experiment_ids, columns are
replicates and pages are c('Dose', 'Viability'), with the corresponding
dose or viability measurement for that experiment_id and replicate.
}

\strong{sensNumber}: Return a count of viability observations in a \code{ToxicoSet}
object for each treatment-combo by sample combination.

\strong{sensNumber<-}: Update the 'n' item, which holds a matrix with a count
of treatment by sample-line experiment counts, in the \code{list} in \verb{@treatmentResponse}
slot of a \code{ToxicoSet} object. Will error when \verb{@sensitviity} contains
a \code{LongTable} object, since the counts are computed on the fly. Arguments:
\itemize{
\item value: A \code{matrix} where rows are samples and columns are treatments, with a
count of the number of experiments for each combination as the values.
}

\strong{pertNumber}: \code{array} Summary of available perturbation experiments
from in a \code{ToxicoSet} object. Returns a 3D \code{array} with the number of
perturbation experiments per treatment and sample, and data type.

\strong{pertNumber<-}: Update the \verb{@perturbation$n} value in a \code{ToxicoSet} object,
which stores a summary of the available perturbation experiments. Arguments:
\itemize{
\item value: A new 3D \code{array} with the number of perturbation experiments per
treatment and sample, and data type
}
}
\examples{
data(TGGATESsmall)
treatmentInfo(TGGATESsmall)

treatmentInfo(TGGATESsmall) <- treatmentInfo(TGGATESsmall)

treatmentNames(TGGATESsmall)

treatmentNames(TGGATESsmall) <- treatmentNames(TGGATESsmall)


## @annotation

annotation(TGGATESsmall)

annotation(TGGATESsmall) <- annotation(TGGATESsmall)

dateCreated(TGGATESsmall)

## dateCreated
dateCreated(TGGATESsmall) <- date()

name(TGGATESsmall)

name(TGGATESsmall) <- 'new_name'

sampleInfo(TGGATESsmall) <- sampleInfo(TGGATESsmall)

sampleNames(TGGATESsmall)

sampleNames(TGGATESsmall) <- sampleNames(TGGATESsmall)

## curation
curation(TGGATESsmall)

curation(TGGATESsmall) <- curation(TGGATESsmall)

datasetType(TGGATESsmall)

datasetType(TGGATESsmall) <- 'both'

# No assay specified
molecularProfiles(TGGATESsmall, 'rna') <- molecularProfiles(TGGATESsmall, 'rna')

# Specific assay
molecularProfiles(TGGATESsmall, 'rna', 'exprs') <-
    molecularProfiles(TGGATESsmall, 'rna', 'exprs')

# Replace the whole slot
molecularProfiles(TGGATESsmall) <- molecularProfiles(TGGATESsmall)

featureInfo(TGGATESsmall, 'rna')

featureInfo(TGGATESsmall, 'rna') <- featureInfo(TGGATESsmall, 'rna')

phenoInfo(TGGATESsmall, 'rna')

phenoInfo(TGGATESsmall, 'rna') <- phenoInfo(TGGATESsmall, 'rna')

fNames(TGGATESsmall, 'rna')

fNames(TGGATESsmall, 'rna') <- fNames(TGGATESsmall, 'rna')

mDataNames(TGGATESsmall)

mDataNames(TGGATESsmall) <- mDataNames(TGGATESsmall)

molecularProfilesSlot(TGGATESsmall)

molecularProfilesSlot(TGGATESsmall) <- molecularProfilesSlot(TGGATESsmall)

sensitivityInfo(TGGATESsmall)

sensitivityInfo(TGGATESsmall) <- sensitivityInfo(TGGATESsmall)

sensitivityMeasures(TGGATESsmall) <- sensitivityMeasures(TGGATESsmall)

sensitivityMeasures(TGGATESsmall) <- sensitivityMeasures(TGGATESsmall)

sensitivityProfiles(TGGATESsmall)

sensitivityProfiles(TGGATESsmall) <- sensitivityProfiles(TGGATESsmall)

head(sensitivityRaw(TGGATESsmall))

sensitivityRaw(TGGATESsmall) <- sensitivityRaw(TGGATESsmall)

treatmentResponse(TGGATESsmall)

treatmentResponse(TGGATESsmall) <- treatmentResponse(TGGATESsmall)

sensNumber(TGGATESsmall)

sensNumber(TGGATESsmall) <- sensNumber(TGGATESsmall)

pertNumber(TGGATESsmall)

pertNumber(TGGATESsmall) <- pertNumber(TGGATESsmall)

}
