% Not generated by roxygen2: do edit by hand
% Please refer to function in R/netCDF.R
\name{ncdf4_convert_from_path}
\alias{ncdf4_convert_from_path}
\title{Convert CDF files to CDF4 from a path automatically}
\usage{
ncdf4_convert_from_path(cdf_path = ".", out_path = cdf_path, recursive = FALSE, ignore.case = TRUE, ...)
}
\arguments{
    \item{cdf_path}{Character string. The path(s) to scan for CDF files.}

    \item{out_path}{Character string. The output path(s) in which the converted files will be saved.}

    \item{recursive}{Logical. Should the search recurse into directories?}

    \item{ignore.case}{Logical. Should the file extension matching be case insensitive?}

    \item{\dots}{Extra options passed to \code{\link[=ncdf4_convert]{ncdf4_convert()}}, which in
        turn can be passed to \code{\link[=baseline]{baseline()}}.}
}
\value{
    A character vector of generated files or invisible.
}
\description{
    Scan and convert NetCDF format 3 files into a custom TargetSearch NetCDF format 4
    automatically. The function scans the given input path(s) for files with \code{"cdf"} extension.
    This function simply wraps around \code{\link[=ncdf4_convert]{ncdf4_convert()}}, so that function
    will then convert each detected file.
}
\details{
    This function simply searches for CDF-3 files and converts them to CDF-4 (custom format). By
    default the current path is scanned and files are converted and save in the same place.

    Multiple input directories can be given. If this is the case, the output path \code{out_path} must
    be either a single path (in which case all files will be copied to the same directory) or an equal
    number of paths, such that there is a corresponding match between input and output directories.
    If not, an assertion error will be raised.

    By default the search is case insensitive (see parameter \code{ignore.case}). For sensitive
    case matching, the function looks for all lowercase extension \code{cdf}. At the moment,
    it is not possible to change this pattern.

    If \code{recursive} is \code{TRUE}, the search will also descend into subdirectories and
    the converted files will follow a similar directory structure. Output directories will be
    created on demand if required (this is actually done by \code{\link[=ncdf4_convert]{ncdf4_convert()}}
    internally).
}
\examples{
# in this example we'll use a temporary directory as source
# and storage of CDF (because we need to reduce testing time in Bioc)

# get some files from package TargetSearchData and copy them
# to `srcdir`
require(TargetSearchData)
cdffiles <- tsd_cdffiles()[1:4]
srcdir <- file.path(tempdir(), 'gc-ms-data')
dir.create(srcdir)
file.copy(cdffiles, srcdir)

# convert to output directory set above
outdir <- tempfile()
ncdf4_convert_from_path(srcdir, outdir)

# recursive search. note that output files will be saved under "gc-ms-data"
# in the output directory
cdfpath <- tempdir() # (base path where we copy the CDF files)
ncdf4_convert_from_path(cdfpath, outdir, recursive=TRUE)

# clean-up the mess
unlink(c(srcdir, outdir), recursive=TRUE)
}
\seealso{
\code{\link[=ncdf4_convert]{ncdf4_convert()}}, \code{\link[=baseline]{baseline()}}
}
\author{
Alvaro Cuadros-Inostroza
}
