% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderCells.R
\name{orderCells}
\alias{orderCells}
\title{Compute pseudotimes from the MST}
\usage{
orderCells(mapping, mst, start = NULL)
}
\arguments{
\item{mapping}{A \linkS4class{DataFrame} of MST-mapping information for each cell,
usually obtained by running \code{\link{mapCellsToEdges}} with the per-cell coordinate matrix and \code{mst}.}

\item{mst}{A \link{graph} object containing a MST from \code{\link{createClusterMST}}.
This need not be generated from the same cells in \code{mapping}.}

\item{start}{A character vector specifying the starting node from which to compute pseudotimes in each component of \code{mst}.
Defaults to an arbitrarily chosen node of degree 1 or lower in each component.}
}
\value{
A \linkS4class{PseudotimeOrdering} object where rows are cells and columns are paths through \code{mst}.
The first entry of \code{\link{pathStats}} contains a numeric matrix with the pseudotimes of each cell in each path.
The \code{\link{cellData}} contains \code{mapping} and the \code{\link{metadata}} contains the chosen \code{start}.
}
\description{
Compute a pseudotime for each cell lying on each path through the MST from a given starting node.
}
\details{
The pseudotimes are returned as a matrix where each row corresponds to cell in \code{x} 
and each column corresponds to a path through the MST from \code{start} to all nodes of degree 1.
(If \code{start} is itself a node of degree 1, then paths are only considered to all other such nodes.)
This format is inspired by that from the \pkg{slingshot} package and provides a compact representation of branching events.

Each branching event in the MST results in a new path and thus a new column in the pseudotime matrix.
An \code{NA} entry for a cell indicates that it is not assigned to that particular path.
All non-\code{NA} entries for any given cell are guaranteed to be identical.
This reflects the fact that multiple paths will share a section of the MST for which the pseudotimes are the same.

If \code{start=NULL}, the starting node is \emph{completely arbitrarily chosen} as directionality is impossible to infer from the expression matrix alone.
However, it is often possible to use prior biological knowledge to pick an appropriate cluster as the starting node.
}
\examples{
# Mocking up a Y-shaped trajectory.
centers <- rbind(c(0,0), c(0, -1), c(1, 1), c(-1, 1))
rownames(centers) <- seq_len(nrow(centers))
clusters <- sample(nrow(centers), 1000, replace=TRUE)
cells <- centers[clusters,]
cells <- cells + rnorm(length(cells), sd=0.5)

# Creating the MST and mapping the cells.
mst <- createClusterMST(cells, clusters=clusters)
mapping <- mapCellsToEdges(cells, mst, clusters=clusters)

# Obtaining pseudo-time orderings.
ordering <- orderCells(mapping, mst)
unified <- rowMeans(pathStat(ordering), na.rm=TRUE)
plot(cells[,1], cells[,2], col=topo.colors(21)[cut(unified, 21)], pch=16)

}
\references{
Ji Z and Ji H (2016).
TSCAN: Pseudo-time reconstruction and evaluation in single-cell RNA-seq analysis.
\emph{Nucleic Acids Res.} 44, e117
}
\seealso{
\code{\link{mapCellsToEdges}}, to compute \code{mapping}.

\code{\link{quickPseudotime}}, a wrapper to quickly perform these calculations.
}
\author{
Aaron Lun
}
