% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weed_raw.R
\name{weed_raw}
\alias{weed_raw}
\title{Weed raw data for corrupt curves}
\usage{
weed_raw(raw_data, checkrange = NULL, checklist = NULL)
}
\arguments{
\item{raw_data}{The raw data for screening.}

\item{checkrange}{list type input identifying range of wells to select.
For example, if viewing first 8 wells from row A to C is needed, one can
specify the row letters and column numbers like this:
\code{checkrange = c("A", "C", "1", "8")}}

\item{checklist}{use this parameter to view selected Wells with full
Well names. For example, \code{checklist = c('A01', 'D11')}}
}
\value{
prompts separate app window for user interaction,
    does not return specific value
}
\description{
The weed_raw function allows users to interact with a screening graph
    and select curves to weed out before entering analysis. Function wraps
    together \code{\link[TSAR]{screen}} and \code{\link{remove_raw}}.
}
\examples{
data("qPCR_data1")
if (interactive()) {
    runApp(weed_raw(qPCR_data1, checkrange = c("A", "B", "1", "12")))
}

}
\seealso{
\code{\link[TSAR]{screen}} and \code{\link{remove_raw}}

Other data_preprocess: 
\code{\link{model_boltzmann}()},
\code{\link{model_fit}()},
\code{\link{model_gam}()},
\code{\link{normalize}()},
\code{\link{remove_raw}()},
\code{\link{run_boltzmann}()},
\code{\link{screen}()},
\code{\link{view_model}()}
}
\concept{data_preprocess}
