% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{import.MAF}
\alias{import.MAF}
\title{import.MAF}
\usage{
import.MAF(
  file,
  sep = "\\t",
  is.TCGA = TRUE,
  filter.fun = NULL,
  to.TRONCO = TRUE,
  irregular = FALSE,
  paste.to.Hugo_Symbol = NULL,
  merge.mutation.types = TRUE,
  silent = FALSE
)
}
\arguments{
\item{file}{MAF filename}

\item{sep}{MAF separator, default \'\\t\'}

\item{is.TCGA}{TRUE if this MAF is from TCGA; thus its sample codenames can be interpreted}

\item{filter.fun}{A filter function applied to each row. This is expected to return TRUE/FALSE.}

\item{to.TRONCO}{If FALSE returns a dataframe with MAF data, not a TRONCO object}

\item{irregular}{If TRUE seeks only for columns Hugo_Symbol, Tumor_Sample_Barcode and Variant_Classification}

\item{paste.to.Hugo_Symbol}{If a list of column names, this will be pasted each Hugo_Symbol to yield names such as PHC2.chr1.33116215.33116215}

\item{merge.mutation.types}{If TRUE, all mutations are considered equivalent, regardless of their Variant_Classification value. Otherwise no.}

\item{silent}{A parameter to disable/enable verbose messages.}
}
\value{
A TRONCO compliant representation of the input MAF
}
\description{
Import mutation profiles from a Manual Annotation Format (MAF) file. All mutations are aggregated as a
unique event type labeled "Mutation" and assigned a color according to the default of function
\code{import.genotypes}. If this is a TCGA MAF file check for multiple samples per patient is performed
and a warning is raised if these occurr. Customized MAF files can be imported as well provided that 
they have columns Hugo_Symbol, Tumor_Sample_Barcode and Variant_Classification. 
Custom filters are possible (via filter.fun) to avoid loading the full MAF data. For details and examples 
regarding the loading functions provided by the package we refer to the Vignette Section 3.
}
\examples{
data(maf)
mutations = import.MAF(maf)
mutations = annotate.description(mutations, 'Example MAF')
mutations = TCGA.shorten.barcodes(mutations)
oncoprint(mutations)

}
