% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Basal.R
\docType{data}
\name{Basal}
\alias{Basal}
\title{Bin-level and region-level data from basal mouse brain samples}
\format{
A list containing two sublists: "Bins" and "Candidates".
In list "Bins", there are,
\describe{
  \item{Bins}{A dataframe of 1000 obs and 5 variables,
  containing the transcriptome location
  for 1000 bins of length 50bps}
  \item{Counts}{A data matrix of 1000 obs and 14 variables,
  caontaining bin-level read counts}
  \item{sf}{A numerical vector,
  containing the size factors of 14 samples
  estimated from the whole transcriptome using
  bin-level read counts.}
  ...
}
In list "Candidates", there are,
\describe{
  \item{Regions}{A dataframe of 500 obs and 5 variables,
  containing the transcriptome location
  of 8011 candidates.}
  \item{Counts}{A data matrix of 500 obs and 14 variables,
  caontaining region-level read counts}
  ...
 }
 Note, bins and regions may or may not overlap with each other,
 as both of them are respectively randomly selected from the
 whole set of bins and candidate regions.
 However, both data share the same size factor for each sample.
}
\usage{
data(Basal)
}
\description{
A data list containing both bin-level and region-level
transcriptome locations and read counts
across 7 paired input and IP replicates from basal mouse brain samples.
It also contains the size factor of each sample
for library size normalization.
}
\keyword{datasets}

