% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpp2dComputeFoldChanges.R
\name{tpp2dComputeFoldChanges}
\alias{tpp2dComputeFoldChanges}
\title{Compute 2D-TPP fold changes}
\usage{
tpp2dComputeFoldChanges(
  configTable = NULL,
  data,
  intensityStr = NULL,
  fcStr = NULL,
  newFcStr = "rel_fc_"
)
}
\arguments{
\item{configTable}{DEPRECATED}

\item{data}{dataframe that contain the data for the 2D-TPP experiment}

\item{intensityStr}{DEPRECATED}

\item{fcStr}{DEPRECATED}

\item{newFcStr}{character string indicating how columns that will contain the actual 
fold change values will be called. The suffix \code{newFcStr} will be pasted in front of
the names of the experiments.}
}
\value{
A data.frame with additional columns with constitute fold changes calculated with 
 respect to the intensity values of the zero treatment column
}
\description{
Computes fold changes by calculating fold changes of the sumionarea 
 relative to the reference column.
}
\examples{
# Preparation:
data(panobinostat_2DTPP_smallExample)

# Import data:
datIn <- tpp2dImport(configTable = panobinostat_2DTPP_config,
                      data = panobinostat_2DTPP_data,
                      idVar = "representative",
                      addCol = "clustername",
                      intensityStr = "sumionarea_protein_",
                      nonZeroCols = "qusm")

# View attributes of imported data (experiment infos and import arguments):
attr(datIn, "importSettings") \%>\% unlist
attr(datIn, "configTable")

# Compute fold changes:
datFC <- tpp2dComputeFoldChanges(data = datIn)

# View updated attributes. Now contain field 'fcStrNorm' indicating prefix
# of the fold change columns after normalization.
attr(datFC, "importSettings")["fcStr"]
                                 
}
