% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funcs.R
\name{plot2dTppVolcano}
\alias{plot2dTppVolcano}
\title{Plot Volcano plot of TPP2D results}
\usage{
plot2dTppVolcano(
  fdr_df,
  hits_df,
  alpha = 0.5,
  title_string = "",
  x_lim = NULL,
  y_lim = NULL,
  facet_by_obs = FALSE
)
}
\arguments{
\item{fdr_df}{data frame obtained from `getFDR`}

\item{hits_df}{hits_df data frame obtained from `findHits`}

\item{alpha}{transparency level of plotted points}

\item{title_string}{character argument handed over to ggtitle}

\item{x_lim}{vector with two numerics indicating the x axis limits}

\item{y_lim}{vector with two numerics indicating the y axis limits}

\item{facet_by_obs}{logical indicating whether plot should be facetted
by number of observations, default: FALSE}
}
\value{
a ggplot displaying a volcano plot of the results
obtained after a TPP2D analysis
}
\description{
Plot Volcano plot of TPP2D results
}
\examples{
data("simulated_cell_extract_df")
temp_df <- simulated_cell_extract_df \%>\%
  filter(clustername \%in\% paste0("protein", 1:5)) \%>\%
  group_by(representative) \%>\%
  mutate(nObs = n()) \%>\%
  ungroup
example_params <- getModelParamsDf(temp_df)
example_fstat <- computeFStatFromParams(example_params)
example_null <- bootstrapNullAlternativeModel(
   df = temp_df, params_df = example_params,
   B = 2)
fdr_df <- getFDR(example_fstat, example_null)
hits_df <- findHits(fdr_df, 0.1)
plot2dTppVolcano(fdr_df = fdr_df, hits_df = hits_df)
}
