% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdr_funcs.R
\name{getPvalues}
\alias{getPvalues}
\title{Compute p-values for given F statistics based on true and
null dataset}
\usage{
getPvalues(df_out, df_null, pseudo_count = 1, squeezeDenominator = FALSE)
}
\arguments{
\item{df_out}{data frame containing results from analysis by
fitAndEvalDataset}

\item{df_null}{data frame containing results from analysis by
bootstrapNull}

\item{pseudo_count}{numeric larger or equal to 0 added to both
counts of protein with an F-statistic higher than a threshold
theta of the true and bootstrapped datasets}

\item{squeezeDenominator}{logical indicating whether F statistic
denominator should be shrinked using limma::squeezeVar}
}
\value{
data frame annotating each protein with a FDR based on 
it's F statistic and number of observations
}
\description{
Compute p-values for given F statistics based on true and
null dataset
}
\examples{
data("simulated_cell_extract_df")
temp_df <- simulated_cell_extract_df \%>\% 
  filter(clustername \%in\% paste0("protein", 1:3)) \%>\% 
  group_by(representative) \%>\% 
  mutate(nObs = n()) \%>\% 
  ungroup 
example_out <- fitAndEvalDataset(temp_df)
example_null <- bootstrapNull(temp_df, B = 2)
getPvalues(
  example_out, 
  example_null)
 
}
