% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_params.R
\name{getModelParamsDf}
\alias{getModelParamsDf}
\title{Get H0 and H1 model parameters}
\usage{
getModelParamsDf(
  df,
  minObs = 20,
  optim_fun_h0 = .min_RSS_h0,
  optim_fun_h1 = .min_RSS_h1_slope_pEC50,
  optim_fun_h1_2 = NULL,
  gr_fun_h0 = NULL,
  gr_fun_h1 = NULL,
  gr_fun_h1_2 = NULL,
  slopEC50 = TRUE,
  maxit = 500,
  qualColName = "qupm"
)
}
\arguments{
\item{df}{tidy data_frame retrieved after import of a 2D-TPP 
dataset, potential filtering and addition of a column "nObs"
containing the number of observations per protein}

\item{minObs}{numeric value of minimal number of observations
that should be required per protein}

\item{optim_fun_h0}{optimization function that should be used
for fitting the H0 model}

\item{optim_fun_h1}{optimization function that should be used
for fitting the H1 model}

\item{optim_fun_h1_2}{optional additional optimization function 
that will be run with paramters retrieved from optim_fun_h1 and 
should be used for fitting the H1 model with the trimmed sum
model, default is NULL}

\item{gr_fun_h0}{optional gradient function for optim_fun_h0,
default is NULL}

\item{gr_fun_h1}{optional gradient function for optim_fun_h1,
default is NULL}

\item{gr_fun_h1_2}{optional gradient function for optim_fun_h1_2,
default is NULL}

\item{slopEC50}{logical flag indicating whether the h1 model is
fitted with a linear model describing the shift od the pEC50 over 
temperatures}

\item{maxit}{maximal number of iterations the optimization
should be given, default is set to 500}

\item{qualColName}{name of column indicating quantification
quality e.g. number of unique peptides used for quantification,
default: "qupm"}
}
\value{
a data.frame with fitted null and alternative model 
parameters
}
\description{
Get H0 and H1 model parameters
}
\examples{
data("simulated_cell_extract_df")
getModelParamsDf(simulated_cell_extract_df)
}
