% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_analysis.R
\name{fitH0Model}
\alias{fitH0Model}
\title{Fit H0 model and evaluate fit statistics}
\usage{
fitH0Model(df, maxit = 500, optim_fun = .min_RSS_h0, gr_fun = NULL)
}
\arguments{
\item{df}{tidy data_frame retrieved after import of a 2D-TPP 
dataset, potential filtering and addition of a column "nObs"
containing the number of observations per protein}

\item{maxit}{maximal number of iterations the optimization
should be given, default is set to 500}

\item{optim_fun}{optimization function that should be used
for fitting the H0 model}

\item{gr_fun}{optional gradient function for optim_fun,
default is NULL}
}
\value{
data frame with H0 model characteristics for each
protein
}
\description{
Fit H0 model and evaluate fit statistics
}
\examples{

data("simulated_cell_extract_df")
temp_df <- simulated_cell_extract_df \%>\% 
  filter(clustername \%in\% paste0("protein", 1:5)) \%>\% 
  group_by(representative) \%>\% 
  mutate(nObs = n()) \%>\% 
  ungroup 
  
fitH0Model(temp_df)

}
