% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_funcs.R
\name{annotateDataList}
\alias{annotateDataList}
\title{Annotate imported data list using a config table}
\usage{
annotateDataList(dataList, geneNameVar, configLong, intensityStr, fcStr)
}
\arguments{
\item{dataList}{list of datasets from different MS runs 
corresponding to a 2D-TPP dataset}

\item{geneNameVar}{character string of the column name that describes
the gene name of a given protein in the raw data files}

\item{configLong}{long formatted data frame of a corresponding
config table}

\item{intensityStr}{character string indicating which columns contain 
raw intensities measurements}

\item{fcStr}{character string indicating which columns contain the actual 
fold change values. Those column names containing the suffix \code{fcStr} 
will be regarded as containing fold change values.}
}
\value{
data frame containing all data annotated
by information supplied in the config table
}
\description{
Annotate imported data list using a config table
}
\examples{
data("config_tab")
data("raw_dat_list")
dataList <- import2dMain(configTable = config_tab,
                         data = raw_dat_list,
                         idVar = "protein_id",
                         fcStr = "rel_fc_",
                         addCol = "gene_name",
                         naStrs = NA,
                         intensityStr = "signal_sum_",
                         nonZeroCols = "qusm",
                         qualColName = "qupm")
configLong <- configWide2Long(configWide = config_tab)
annotateDataList(dataList = dataList,
                 geneNameVar = "gene_name",
                 configLong = configLong,
                 intensityStr = "signal_sum_",
                 fcStr = "rel_fc_")
}
