% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOP_model.R
\name{predict_TOP}
\alias{predict_TOP}
\title{Prectict using the Trasferable Omics Prediction model.}
\usage{
predict_TOP(TOP_model, newx, covariates = NULL, s = "lambda.min")
}
\arguments{
\item{TOP_model}{The output from the TOP_model function.}

\item{newx}{A matrix of the new data to be predicted. The columns should be
features and the rows should be samples.}

\item{covariates}{A data frame of the same covariates that were used in the
TOP model, Default: NULL}

\item{s}{Lambda value for the lasso model, Default: 'lambda.min'}
}
\value{
A vector of predictions for the new data.
}
\description{
A prediction function for the Trasferable Omics Prediction
model.
}
\examples{
data(TOP_data_binary, package = "TOP")

x1 <- TOP_data_binary$x1
x2 <- TOP_data_binary$x2
x3 <- TOP_data_binary$x3
y1 <- TOP_data_binary$y1
y2 <- TOP_data_binary$y2
y3 <- TOP_data_binary$y3

set.seed(23)
x_list <- list(x1, x2)
y_list <- list(factor(y1), factor(y2))

model <- TOP_model(x_list, y_list)
predictions <- predict_TOP(model$models, newx = x3)
}
