% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Performance.R
\name{performance_TOP}
\alias{performance_TOP}
\title{performance_TOP}
\usage{
performance_TOP(TOP_model, newx, newy, covariates = NULL, s = "lambda.min")
}
\arguments{
\item{TOP_model}{This is the output of the function TOP_model.}

\item{newx}{A matrix of the new data to be predicted. With the same number
of feature columns as the original data.}

\item{newy}{A vector of the true labels that are being predicted. With the
same number of samples as newx.}

\item{covariates}{A data.frame of the same covariates as the original TOP
model, Default: NULL}

\item{s}{Lambda used in the lasso model, Default: 'lambda.min'}
}
\value{
A confusion matrix that displays the performance of the classifier.
}
\description{
A function to calculate the external performance of the
Tranferable Omics Prediction model.
}
\examples{

data(TOP_data_binary, package = "TOP")
x1 <- TOP_data_binary$x1
x2 <- TOP_data_binary$x2

x_list <- list(x1,x2)
y_list <- list(TOP_data_binary$y1, TOP_data_binary$y2)

model <- TOP_model(x_list, y_list)

x3 <- TOP_data_binary$x3
y3 <- TOP_data_binary$y3

performance_TOP(model$models, newx = x3, newy = y3)

}
