% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseIncidence.R
\name{sparseIncidence}
\alias{sparseIncidence}
\alias{sparseIncidence,GeneSet-method}
\alias{sparseIncidence,GeneSetCollection-method}
\title{Construct a Sparse Incidence Matrix}
\usage{
sparseIncidence(x, ...)

\S4method{sparseIncidence}{GeneSet}(x, ...)

\S4method{sparseIncidence}{GeneSetCollection}(x, ...)
}
\arguments{
\item{x}{a named list of sets. Elements must be of type \code{"character"}.}

\item{...}{additional arguments are not currently used.}
}
\value{
An object of class \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}}
with unique set names as rows and unique elements as columns.
}
\description{
Construct a sparse incidence matrix from a named list of sets.
}
\details{
\code{sparseIncidence} differs from
\code{\link[GSEABase:incidence]{GSEABase::incidence}} in that it returns a
sparse matrix, rather than a dense matrix, so it is more memory efficient.
It also removes missing elements, removes empty sets, and combines sets
with duplicate names.
}
\section{Incidence Matrix}{


An incidence matrix, \eqn{A}, is defined such that

\deqn{A_{ij} = \begin{cases} 1, & \text{if } \text{element } e_j \in
  \text{set } s_i \\ 0, & \text{otherwise} \end{cases}}
}

\examples{
x <- list("A" = c("a", "b"),
          "A" = c("c"), # duplicate sets
          "B" = c("c", "d"),
          "C" = c("x", "y", "z", "z"), # duplicates
          "D" = c("a", NA)) # missing values

(imat <- sparseIncidence(x))

# Sizes of sets and their pairwise intersections
tcrossprod(imat)

# Number of sets in which each element and pair of elements appears
crossprod(imat)

# Count number of elements unique to each set
keep <- apply(imat, 2, sum) == 1
apply(imat[, keep], 1, sum)

}
\seealso{
\code{\link{incidenceToList}}, \code{\link{similarity}},
\code{\link[Matrix]{sparseMatrix}}
}
